% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/place_order_crypto.R
\name{place_order_crypto}
\alias{place_order_crypto}
\title{Place a crypto currency buy or sell order against your RobinHood account}
\usage{
place_order_crypto(RH, symbol, type, time_in_force, price, quantity, side)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{symbol}{(string) Ticket symbol you are attempting to buy or sell}

\item{type}{(string) "market" or "limit"}

\item{time_in_force}{(string) Good Till Canceled ("gtc"), Immediate or Cancel ("ioc"), or Opening ("opg")}

\item{price}{(number) the price you are willing to sell or buy at}

\item{quantity}{(int) number of shares you wish to transact}

\item{side}{(string) "buy" or "sell"}
}
\description{
Place a crypto currency buy or sell order against your RobinHood account
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

# Place an order, should generate an email confirmation
x <- place_order_crypto(RH = RH,
                       symbol = "DOGE",        # Ticker symbol
                       type = "market",        # Type of market order (market, limit)
                       time_in_force = "gtc",  # Time period (gfd: good for day)
                       price = .003,           # The highest price you are willing to pay
                       quantity = 500,         # Number of shares you want
                       side = "buy")           # buy or sell
}
}
