% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_effect.R
\name{treatment_effect}
\alias{treatment_effect}
\alias{difference}
\alias{risk_ratio}
\alias{odds_ratio}
\title{Treatment Effect}
\usage{
treatment_effect(
  object,
  pair = pairwise(names(object$estimate)),
  eff_measure,
  eff_jacobian = eff_jacob(eff_measure),
  ...
)

difference(object, ...)

risk_ratio(object, ...)

odds_ratio(object, ...)
}
\arguments{
\item{object}{Object from which to obtain treatment effect.}

\item{pair}{(\code{contrast}) Contrast choices.}

\item{eff_measure}{(\code{function}) Treatment effect measurement function.}

\item{eff_jacobian}{(\code{function}) Treatment effect jacobian function.}

\item{...}{Additional arguments for variance.}
}
\value{
A list of \code{treatment_effect} object with following elements:
\itemize{
\item \code{estimate}: estimate of the treatment effect.
\item \code{pair}: \code{contrast} object indicating the pairwise treatment effect.
\item \code{contrast}: name of the contrast function.
\item \code{euqal_val}: the value for no treatment effect given the contrast.
\item \code{marginal_mean}: the \code{prediction_cf} object.
\item \code{fit}: the fitted model.
\item \code{treatment}: the treatment assignment.
\item \code{variance}: the variance of the treatment effect.
\item \code{jacobian}: the Jacobian matrix.
}
}
\description{
Obtain treatment effect and variance from counter-factual prediction
}
