% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.RoBSA}
\alias{plot.RoBSA}
\title{Plots a fitted RoBSA object}
\usage{
\method{plot}{RoBSA}(
  x,
  parameter = NULL,
  conditional = FALSE,
  plot_type = "base",
  prior = FALSE,
  dots_prior = NULL,
  ...
)
}
\arguments{
\item{x}{a fitted RoBSA object}

\item{parameter}{a name of parameter to be plotted. Defaults to
the first regression parameter if left unspecified. Use
\code{"intercept"} and \code{"aux"} to plot the intercepts and
auxiliary parameters of each distribution family.}

\item{conditional}{whether conditional estimates should be
plotted. Defaults to \code{FALSE} which plots the model-averaged
estimates.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{prior}{whether prior distribution should be added to
figure. Defaults to \code{FALSE}.}

\item{dots_prior}{list of additional graphical arguments
to be passed to the plotting function of the prior
distribution. Supported arguments are \code{lwd},
\code{lty}, \code{col}, and \code{col.fill}, to adjust
the line thickness, line type, line color, and fill color
of the prior distribution respectively.}

\item{...}{list of additional graphical arguments
to be passed to the plotting function. Supported arguments
are \code{lwd}, \code{lty}, \code{col}, \code{col.fill},
\code{xlab}, \code{ylab}, \code{main}, \code{xlim}, \code{ylim}
to adjust the line thickness, line type, line color, fill color,
x-label, y-label, title, x-axis range, and y-axis range
respectively.}
}
\value{
\code{plot.RoBSA} returns either \code{NULL} if \code{plot_type = "base"}
or an object object of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{plot.RoBSA} allows to visualize
posterior distribution of different \code{"RoBSA"} object
parameters. See \code{plot_survival} for plotting the survival
ways. See \code{type} for the different model types.
}
\examples{
\dontrun{
# (execution of the example takes several minutes)
# example from the README (more details and explanation therein)
data(cancer, package = "survival")
priors <- calibrate_quartiles(median_t = 5, iq_range_t = 10, prior_sd = 0.5)
df <- data.frame(
  time         = veteran$time / 12,
  status       = veteran$status,
  treatment    = factor(ifelse(veteran$trt == 1, "standard", "new"), levels = c("standard", "new")),
  karno_scaled = veteran$karno / 100
)
RoBSA.options(check_scaling = FALSE)
fit <- RoBSA(
  Surv(time, status) ~ treatment + karno_scaled,
  data   = df,
  priors = list(
    treatment    = prior_factor("normal", parameters = list(mean = 0.30, sd = 0.15),
                                truncation = list(0, Inf), contrast = "treatment"),
    karno_scaled = prior("normal", parameters = list(mean = 0, sd = 1))
  ),
  test_predictors = "treatment",
  prior_intercept = priors[["intercept"]],
  prior_aux       = priors[["aux"]],
  parallel = TRUE, seed = 1
)

# plot posterior distribution of the treatment effect
plot(fit, parameter = "treatment")

}


}
\seealso{
\code{\link[=RoBSA]{RoBSA()}}
}
