% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatTools.R
\name{plotScores}
\alias{plotScores}
\title{plotScores}
\usage{
plotScores(
  data,
  pc1,
  pc2,
  samples,
  factor = NULL,
  cexlabel = 1.2,
  level = 0.95,
  xlim = NULL,
  ylim = NULL,
  col = NULL
)
}
\arguments{
\item{data}{the matrix of scores coming from a multivariable analysis, typically a Principal Component Analysis (PCA)}

\item{pc1}{the fist component of the matrix of variable loadings to be plotted.}

\item{pc2}{the second component of the matrix of variable loadings to be plotted.
as well as the levels of the experimental factors if specified in the input. 
See \code{doProcessing} or \code{generateMetadata}}

\item{samples}{the samples matrix with the correspondence of the raw spectra,}

\item{factor}{if not null, the name of one of the columns defining the factorial groups in the samples matrix at input}

\item{cexlabel}{number indicating the amount by which plotting text and symbols should be scaled relative to the default.}

\item{level}{confidence level for plotting the corresponding ellipse}

\item{xlim}{gives the limit to be plotted of the first component}

\item{ylim}{gives the limit to be plotted of the second component}

\item{col}{colors vector for ellipses - automatically defined by default}
}
\description{
Plots the two components defined by pc1, pc2 of the matrix of scores coming from a 
multivariable analysis, typically a Principal Component Analysis (PCA).
}
