% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T2_MRF_test.R
\name{CompareMRF_T2}
\alias{CompareMRF_T2}
\title{Comparison of two MRFs using Hotellings T2}
\usage{
CompareMRF_T2(X, Y, L1, vertices = NULL, subset = NULL, B = 500,
  n_b = 0.5, replace = T, seed = NULL)
}
\arguments{
\item{X}{A dataset to be used to estimate an MRF/Rnet}

\item{Y}{A dataset to be used to estimate an MRF/Rnet}

\item{L1}{The regularization pentalty to use for both networks}

\item{vertices}{Vertices to include in MRF. Must be a subset of names(x)}

\item{subset}{An expression for the subsetting X and Y based on columns not used in the MRF. Appled to both data sets}

\item{B}{The number of subsamples to draw. The same number of subsamples is drawn from both data sets.}

\item{n_b}{The size of the subsamples. May be provided as an integer less than the number of rows in x, or as a proportion.}

\item{replace}{Logical. Is subsampling done with (T) or without (F) replacement.}

\item{seed}{Random seed value for reproducibility. The same seed is applied to sampling from both data sets.}
}
\value{
An S3 object of class 'mrf_t2' containing crude test results, adjusted test results, and a table of pair-wise comparisons of unique edges
}
\description{
Hotelling's T2 is the multivariate extension of Welch's t-test used to compare two sets of means. The test is used here to test for differences in the penalized partial correlations in two diffrent MRFs.
}
