% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sq2L.R
\name{Sq2L}
\alias{Sq2L}
\title{Matrix reshaping function}
\usage{
Sq2L(x, output.col.names = NULL, keep = c(T, T, T), drop.values = 0,
  drop.NA = T)
}
\arguments{
\item{x}{A square matrix to reshape into a dataframe.}

\item{output.col.names}{A vector indicating how output columns are named.}

\item{keep}{A logical vector of length 3 indicating which of the three respective elements to keep: upper triangle, main diagonal, and lower triangle.}

\item{drop.values}{A vector of values to remove from the output.}

\item{drop.NA}{Logical value indicating if NAs should be removed.}
}
\value{
a data.frame with three columns. Columns 1 & 2 contain the row & column names, and third contains corresponding matrix values.
}
\description{
This function resphapes all or parts of a square matrix into a 3 column table.
}
\examples{
demo_mat <- matrix(c(1, 5, 2, 5, 1, 0, 2, 0, NA), nrow = 3)
Sq2L(demo_mat, c('A', 'B', 'value'))
Sq2L(demo_mat, c('A', 'B', 'value'), drop.values = 0, drop.NA = FALSE)
}
