% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_Tests.R
\name{SWTest}
\alias{SWTest}
\title{Shapiro-Wilk Test}
\usage{
SWTest(data, alpha = 0.05, j = 1)
}
\arguments{
\item{data}{Data of a univariate distribution for which the test statistic is computed
(vector)}

\item{alpha}{The two-sided decision threshold used for hypothesis-testing}

\item{j}{The # hypotheses tested; used to compute a Bonferonni correction, if applicable;
should remain at its default if multiple testing is not an issue (scalar)}
}
\value{
An object including the test statistic, p-value, and a significance flag (list)
}
\description{
This function is a wrapper for shapiro.test() from the stats package. Options
added include an ability to toggle a Bonferonni correction for significance, a
corresponding significance flag, and reorganized output to facilitate integration
with the Rita package.
}
\examples{
values <- rnorm(100)
x <- SWTest(data = values)
}
\references{
Patrick Royston (1982). An extension of Shapiro and Wilk's W test for normality to large samples. Applied Statistics, 31, 115--124. 10.2307/2347973

            Patrick Royston (1982). Algorithm AS 181: The W test for Normality. Applied Statistics, 31, 176--180. 10.2307/2347986

            Patrick Royston (1995). Remark AS R94: A remark on Algorithm AS 181: The W test for normality. Applied Statistics, 44, 547--551. 10.2307/2986146
}
