% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory_analysis.R
\name{plot_s_variogram}
\alias{plot_s_variogram}
\title{Plotting the empirical variogram}
\usage{
plot_s_variogram(variog_output, plot_envelope = FALSE, color = "royalblue1")
}
\arguments{
\item{variog_output}{The output generated by the function \code{\link{s_variogram}}.}

\item{plot_envelope}{A logical value indicating if the envelope of spatial independence
generated using the permutation test must be displayed (\code{plot_envelope = TRUE}) or not
(\code{plot_envelope = FALSE}). By default \code{plot_envelope = FALSE}. Note: if \code{n_permutation = 0} when
running the function \code{\link{s_variogram}}, the function will display an error message because no envelope can be generated.}

\item{color}{If \code{plot_envelope = TRUE}, it sets the colour of the envelope; run \code{vignette("ggplot2-specs")} for more details on this argument.}
}
\value{
A \code{ggplot} object representing the empirical variogram plot, optionally including the envelope of spatial independence.
}
\description{
Plots the empirical variogram generated by \code{\link{s_variogram}}
}
\details{
This function plots the empirical variogram, which shows the spatial dependence structure of the data. If \code{plot_envelope} is set to \code{TRUE}, the plot will also include an envelope indicating the range of values under spatial independence, based on a permutation test.
}
\seealso{
\code{\link{s_variogram}}
}
