% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/media.R
\name{ig_comment_delete_bulk}
\alias{ig_comment_delete_bulk}
\title{Delete Comments on a Post in Bulk}
\usage{
ig_comment_delete_bulk(media_id, comment_id, verbose = FALSE)
}
\arguments{
\item{media_id}{numeric; the unique id to identify a post which can be 
found in the \code{id}, not the \code{pk} field, of posts returned via many of 
the functions retrieving feeds.}

\item{comment_id}{numeric; the unique id to identify a post which can be 
found in the \code{"id"} on other comments returned via the Instagram API}

\item{verbose}{logical; do you want informative messages?}
}
\description{
This function takes the \code{media_id} of a post as well as one or more \code{comment_id}s 
and then deletes all of those comments
}
\examples{
\donttest{
last_post_media_id <- ig_my_timeline(paginate = FALSE)$id[1]
comment_result1 <- ig_comment(last_post_media_id, 
                             comment_text = "New Comment #1")
comment1_media_id <- comment_result1$comment$media_id 
comment_result2 <- ig_comment(last_post_media_id, 
                             comment_text = "New Comment #2")
comment2_media_id <- comment_result2$comment$media_id                               
deletion_result <- ig_comment_delete(last_post_media_id, 
                                     c(comment1_media_id, 
                                       comment2_media_id))
}
}
