% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_power.R
\name{gof_power}
\alias{gof_power}
\title{Find the power of various gof tests for continuous data.}
\usage{
gof_power(
  pnull,
  vals = NA,
  rnull,
  ralt,
  param_alt,
  w = function(x) -99,
  phat = function(x) -99,
  TS,
  TSextra = NA,
  alpha = 0.05,
  Range = c(-Inf, Inf),
  B = 1000,
  nbins = c(50, 10),
  rate = 0,
  maxProcessor,
  minexpcount = 5,
  ChiUsePhat = TRUE
)
}
\arguments{
\item{pnull}{function to find cdf under  null hypothesis}

\item{vals}{=NA, values of rv, if data is discrete, NA if data is continuous}

\item{rnull}{function to generate data under  null hypothesis}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{w}{(Optional) function to calculate weights, returns -99 if no weights}

\item{phat}{=function(x) -99 function to estimate parameters from the data, or -99}

\item{TS}{user supplied function to find test statistics}

\item{TSextra}{=NA, list provided to TS}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{Range}{=c(-Inf, Inf) limits of possible observations, if any}

\item{B}{=1000 number of simulation runs}

\item{nbins}{=c(100,10), number of bins for chi square tests.}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{maxProcessor}{maximum of number of processors to use, 1 if no parallel processing is needed or number of cores-1 if missing}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{= TRUE, if TRUE param is estimated parameter, otherwise minimum chi square method is used.}
}
\value{
A numeric matrix of power values.
}
\description{
Find the power of various gof tests for continuous data.
}
\examples{
# Power of tests when null hypothesis specifies the standard normal distribution but 
# true data comes from a normal distribution with mean different from 0.
pnull = function(x) pnorm(x)
rnull = function()  rnorm(50)
ralt = function(mu)  rnorm(50, mu)
TSextra = list(qnull=function(x) qnorm(x))
gof_power(pnull, NA, rnull, ralt, c(0.25, 0.5), TSextra=TSextra, B=200)
# Power of tests when null hypothesis specifies normal distribution and 
# mean and standard deviation are estimated from the data. 
# Example is not run because it takes several minutes.
# true data comes from a normal distribution with mean different from 0.
pnull = function(x, p=c(0, 1)) pnorm(x, p[1], ifelse(p[2]>0.001, p[2], 0.001))
rnull = function(p=c(0, 1))  rnorm(50, p[1], ifelse(p[2]>0.001, p[2], 0.001))
phat = function(x) c(mean(x), sd(x))
TSextra = list(qnull = function(x, p=c(0, 1)) qnorm(x, p[1],  
               ifelse(p[2]>0.001, p[2], 0.001))) 
gof_power(pnull, NA, rnull, ralt, c(0, 1), phat=phat, TSextra=TSextra, B=200)
# Power of tests when null hypothesis specifies Poisson rv with rate 100 and 
# true rate is 100.5
vals = 0:250
pnull = function() ppois(0:250, 100)
rnull =function () table(c(0:250, rpois(1000, 100)))-1
ralt =function (p) table(c(0:250, rpois(1000, p)))-1
gof_power(pnull, vals, rnull, ralt, param_alt=100.5,  B=200)
# Power of tests when null hypothesis specifies a Binomial n=10 distribution 
# with the success probability estimated
vals = 0:10
pnull=function(p) pbinom(0:10, 10, ifelse(0<p&p<1, p, 0.001))
rnull=function(p) table(c(0:10, rbinom(1000, 10, ifelse(0<p&p<1, p, 0.001))))-1
ralt=function(p) table(c(0:10, rbinom(1000, 10, p)))-1
phat=function(x) mean(rep(0:10,x))/10
gof_power(pnull, vals, rnull, ralt, c(0.5, 0.6), phat=phat, B=200)

}
