% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fssaplot.R
\name{plot.fssa}
\alias{plot.fssa}
\title{Plot Functional Singular Spectrum Analysis Objects}
\usage{
\method{plot}{fssa}(x, d = length(x$values), idx = 1:d, idy = idx +
  1, contrib = TRUE, groups = as.list(1:d), type = "values",
  var = 1L, ylab = NA, ...)
}
\arguments{
\item{x}{an object of class \code{\link{fssa}}}

\item{d}{an integer which is the number of elementary components in the plot}

\item{idx}{a vector of indices of eigen elements to plot}

\item{idy}{a second vector of indices of eigen elements to plot (for type="paired")}

\item{contrib}{a logical where if the value is 'TRUE' (the default), the contribution of the component to the total variance is displayed}

\item{groups}{a list or vector of indices determines grouping used for the decomposition(for type="wcor")}

\item{type}{the type of plot to be displayed where possible types are:
\itemize{
\item \code{"values"} plot the square-root of singular values (default)
\item \code{"paired"} plot the pairs of eigenfunction's coefficients (useful for the detection of periodic components)
\item \code{"wcor"} plot the W-correlation matrix for the reconstructed objects
\item \code{"vectors"} plot the eigenfunction's coefficients (useful for the detection of period length)
\item \code{"lcurves"} plot of the eigenfunctions (useful for the detection of period length)
\item \code{"lheats"} heatmap plot the eigenfunctions (useful for the detection of meaningful patterns)
\item \code{"periodogram"} periodogram plot (useful for the detecting the frequencies of oscillations in functional data)
}}

\item{var}{an integer specifying the variable number}

\item{ylab}{the character vector of name of variables}

\item{...}{arguments to be passed to methods, such as graphical parameters}
}
\description{
This is a plotting method for objects of class functional singular spectrum analysis (\code{\link{fssa}}). The method is designed to help the user make decisions
 on how to do the grouping stage of univariate or multivariate functional singular spectrum analysis.
}
\note{
for a multivariate example, see the examples in \code{\link{fssa}}
}
\examples{
\dontrun{
## Simulated Data Example
require(Rfssa)
require(fda)
n <- 50 # Number of points in each function.
d <- 9
N <- 60
sigma <- 0.5
set.seed(110)
E <- matrix(rnorm(N*d,0,sigma/sqrt(d)),ncol = N, nrow = d)
basis <- create.fourier.basis(c(0, 1), d)
Eps <- fd(E,basis)
om1 <- 1/10
om2 <- 1/4
f0 <- function(tau, t) 2*exp(-tau*t/10)
f1 <- function(tau, t) 0.2*exp(-tau^3) * cos(2 * pi * t * om1)
f2 <- function(tau, t) -0.2*exp(-tau^2) * cos(2 * pi * t * om2)
tau <- seq(0, 1, length = n)
t <- 1:N
f0_mat <- outer(tau, t, FUN = f0)
f0_fd <- smooth.basis(tau, f0_mat, basis)$fd
f1_mat <- outer(tau, t, FUN = f1)
f1_fd <- smooth.basis(tau, f1_mat, basis)$fd
f2_mat <- outer(tau, t, FUN = f2)
f2_fd <- smooth.basis(tau, f2_mat, basis)$fd
Y_fd <- f0_fd+f1_fd+f2_fd
L <-10
U <- fssa(Y_fd,L)
plot(U)
plot(U,d=4,type="lcurves")
plot(U,d=4,type="vectors")
plot(U,d=5,type="paired")
plot(U,d=5,type="wcor")
plot(U,d=5,type="lheats")
plot(U,d=5,type="periodogram")
}
}
\seealso{
\code{\link{fssa}}, \code{\link{plot.fts}}
}
