% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openapi.R
\name{openapi}
\alias{openapi}
\alias{openapi_create}
\alias{openapi_openapi_version}
\alias{openapi_info}
\alias{openapi_servers}
\alias{openapi_server}
\alias{openapi_contact}
\alias{openapi_license}
\title{Builds OpenAPI objects}
\usage{
openapi_create(openapi = openapi_openapi_version(),
  info = openapi_info(), servers = openapi_servers(), ...)

openapi_openapi_version(openapi_version = "3.0.1")

openapi_info(title = "RestRserve OpenAPI", version = "1.0",
  description = NULL, termsOfService = NULL,
  contact = openapi_contact(), license = openapi_license())

openapi_servers(servers = list(openapi_server()))

openapi_server(url = "/", description = NULL, variables = NULL)

openapi_contact(name = NULL, url = NULL, email = NULL)

openapi_license(name = NULL, url = NULL)
}
\arguments{
\item{openapi}{string, version of open api. For example \code{"3.0.1"}}

\item{info}{infoObject - \url{https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.1.md#infoObject}.
See \link{openapi_info}}

\item{servers}{serverObject -
\url{https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.1.md#serverObject}
See \link{openapi_servers}}

\item{...}{other parameters - see
\url{https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.1.md#oasObject}}

\item{openapi_version}{version on OpenAPI}

\item{title}{the title of the application}

\item{version}{version of the application}

\item{description}{description}

\item{termsOfService}{termsOfService of the application}

\item{contact}{contact of the maintainer - see \link{openapi_contact}}

\item{license}{license of the api}

\item{url}{url}

\item{variables}{a map between a variable name and its value.
#The value is used for substitution in the server's URL template.}

\item{name}{name}

\item{email}{contact email}
}
\description{
Facilitates in building \href{https://www.openapis.org/}{OpenAPI} description document by
creating objects described in
\url{https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.1.md}
}
\details{
\url{https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.1.md#infoObject}
}
\keyword{internal}
