% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthMiddleware.R
\docType{data}
\name{AuthMiddleware}
\alias{AuthMiddleware}
\title{Creates authorization middleware object}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Adds various authorizations to \link{Application}.
This class inherits \link{Middleware}.
}
\section{Construction}{
\preformatted{AuthMiddleware$new(auth_backend, routes, match = "exact", id = "AuthMiddleware")
}
\itemize{
\item \code{auth_backend} :: \link{AuthBackend}\cr
Authentication backend.
\item \code{routes} :: \code{character()}\cr
Routes paths to protect.
\item \code{match} :: \code{character()}\cr
How routes will be matched: \code{"exact"} or \code{"partial"} (as prefix).
\item \code{id} :: \code{character(1)}\cr
Middleware id
}
}

\seealso{
\link{Middleware} \link{Application}

Other AuthBackend: \code{\link{AuthBackendBasic}},
  \code{\link{AuthBackendBearer}},
  \code{\link{AuthBackend}}
}
\concept{AuthBackend}
\keyword{datasets}
