% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{weather_data}
\alias{weather_data}
\title{Weather data from one measuring station.}
\format{
A data frame with the following of variables: 

\describe{
\item{\code{WIND_DIRECTION}}{Wind direction in compass degrees.
  *NA* when air is calm (no wind speed)}
\item{\code{CLOUD_CEILING}}{Lowest opaque layer with 5/8 or greater
  coverage}
\item{\code{SKY_COVER}}{Sky cover: CLR-clear, SCT-scattered (1/8 to 4/8),
  BKN-broken (5/8 to 7/8), OVC-overcast, OBS-obscured, POB-partial obscuration}
\item{\code{VISIBILITY}}{Visibilityin statute miles (rounded to nearest tenth)}
\item{\code{TEMP}}{Temperature measured in fahrenheit}
\item{\code{SEA_LEVEL_PRESSURE}}{Sea level pressure measured in millibars (rounded to nearest tenth)}
\item{\code{STATION_PRESSURE}}{Station pressure measured in millibars (rounded to nearest tenth)}
\item{\code{MAXIMUM_TEMPERATURE}}{Maximum temperature measured in fahrenheit}
\item{\code{MINIMUM_TEMPERATURE}}{Minimum temperature measured in fahrenheit}
\item{\code{PCP01}}{1-hour liquid precip reportin inches and hundredths,
  that is, the precip for the preceding 1-hour period}
\item{\code{SNOW_DEPTH}}{Snow depth in inches}
\item{\code{WIND_SPEED}}{Wind speed in miles per hour}
\item{\code{DEW_POINT}}{Dew point measured in fahrenheit}
}
}
\usage{
weather_data
}
\description{
Weather data from a weather station in a central location of the study region. The
data contains hourly measurements over a period of ten weeks, similar to the timespan of the dataset *elcons_15min*.
}
\details{
This data cannot be used or redistributed for commercial purposes. Re-distribution 
of these data by others must provide this same notification. 
(see \url{https://www.ncdc.noaa.gov/})
}
\references{
NOAA National Centers for Environmental Information (2020)
}
\keyword{datasets}
