/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.preprocess;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.common.preprocess.PageNumberInformation;
import org.docx4j.convert.out.common.preprocess.PageNumberInformationCollector;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.STPageOrientation;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SectPr;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionSectionWrapperFactory {
    protected static Logger log = LoggerFactory.getLogger(ConversionSectionWrapperFactory.class);

    public static ConversionSectionWrappers process(WordprocessingMLPackage wmlPackage, boolean dummySections, boolean dummyPageNumbering) {
        List<ConversionSectionWrapper> conversionSections = null;
        Document document = (Document)wmlPackage.getMainDocumentPart().getJaxbElement();
        RelationshipsPart rels = wmlPackage.getMainDocumentPart().getRelationshipsPart();
        BooleanDefaultTrue evenAndOddHeaders = null;
        if (wmlPackage.getMainDocumentPart().getDocumentSettingsPart() != null && wmlPackage.getMainDocumentPart().getDocumentSettingsPart().getJaxbElement() != null) {
            evenAndOddHeaders = ((CTSettings)wmlPackage.getMainDocumentPart().getDocumentSettingsPart().getJaxbElement()).getEvenAndOddHeaders();
        }
        conversionSections = dummySections ? ConversionSectionWrapperFactory.processDummy(wmlPackage, document, rels, evenAndOddHeaders, dummyPageNumbering) : ConversionSectionWrapperFactory.processComplete(wmlPackage, document, rels, evenAndOddHeaders, dummyPageNumbering);
        return new ConversionSectionWrappers(conversionSections);
    }

    protected static List<ConversionSectionWrapper> processDummy(WordprocessingMLPackage wmlPackage, Document document, RelationshipsPart rels, BooleanDefaultTrue evenAndOddHeaders, boolean dummyPageNumbering) {
        ArrayList<ConversionSectionWrapper> conversionSections = new ArrayList<ConversionSectionWrapper>();
        ConversionSectionWrapper currentSectionWrapper = null;
        HeaderFooterPolicy previousHF = new HeaderFooterPolicy(document.getBody().getSectPr(), null, rels, evenAndOddHeaders);
        currentSectionWrapper = ConversionSectionWrapperFactory.createSectionWrapper(document.getBody().getSectPr(), previousHF, rels, evenAndOddHeaders, 1, document.getBody().getContent(), dummyPageNumbering);
        conversionSections.add(currentSectionWrapper);
        return conversionSections;
    }

    protected static List<ConversionSectionWrapper> processComplete(WordprocessingMLPackage wmlPackage, Document document, RelationshipsPart rels, BooleanDefaultTrue evenAndOddHeaders, boolean dummyPageNumbering) {
        ArrayList<ConversionSectionWrapper> conversionSections = new ArrayList<ConversionSectionWrapper>();
        ArrayList<Object> sectionContent = new ArrayList<Object>();
        ConversionSectionWrapper currentSectionWrapper = null;
        HeaderFooterPolicy previousHF = null;
        int conversionSectionIndex = 0;
        SdtBlockFinder sbr = new SdtBlockFinder();
        new TraversalUtil(document.getContent(), sbr);
        for (int i = sbr.sdtBlocks.size() - 1; i >= 0; --i) {
            SdtBlock sdtBlock = sbr.sdtBlocks.get(i);
            ArrayList parentList = null;
            if (sdtBlock.getParent() instanceof ArrayList) {
                parentList = (ArrayList)sdtBlock.getParent();
            } else {
                log.error("Handle " + sdtBlock.getParent().getClass().getName());
            }
            int index = parentList.indexOf(sdtBlock);
            parentList.remove(index);
            parentList.addAll(index, sdtBlock.getSdtContent().getContent());
        }
        ArrayList<SectPr> sectPrs = new ArrayList<SectPr>();
        for (Object o : document.getBody().getContent()) {
            PPr ppr;
            if (!(o instanceof P) || ((P)o).getPPr() == null || (ppr = ((P)o).getPPr()).getSectPr() == null) continue;
            sectPrs.add(ppr.getSectPr());
        }
        sectPrs.add(document.getBody().getSectPr());
        int sectPrIndex = 0;
        for (Object o : document.getBody().getContent()) {
            PPr ppr;
            if (o instanceof P && ((P)o).getPPr() != null && (ppr = ((P)o).getPPr()).getSectPr() != null) {
                SectPr followingSectPr;
                boolean ignoreThisSection = false;
                if ((followingSectPr = (SectPr)sectPrs.get(++sectPrIndex)).getType() != null && followingSectPr.getType().getVal().equals("continuous")) {
                    ignoreThisSection = true;
                    SectPr.PgSz pgSzThis = ppr.getSectPr().getPgSz();
                    SectPr.PgSz pgSzNext = followingSectPr.getPgSz();
                    if (pgSzThis != null && pgSzNext != null) {
                        if (pgSzThis.getH().compareTo(pgSzNext.getH()) != 0) {
                            ignoreThisSection = false;
                        }
                        if (pgSzThis.getW().compareTo(pgSzNext.getW()) != 0) {
                            ignoreThisSection = false;
                        }
                        boolean portraitThis = true;
                        if (pgSzThis.getOrient() != null) {
                            portraitThis = pgSzThis.getOrient().equals((Object)STPageOrientation.PORTRAIT);
                        }
                        boolean portraitNext = true;
                        if (pgSzNext.getOrient() != null) {
                            portraitNext = pgSzNext.getOrient().equals((Object)STPageOrientation.PORTRAIT);
                        }
                        if (portraitThis != portraitNext) {
                            ignoreThisSection = false;
                        }
                    }
                }
                if (ignoreThisSection) {
                    previousHF = new HeaderFooterPolicy(ppr.getSectPr(), previousHF, rels, evenAndOddHeaders);
                } else {
                    currentSectionWrapper = ConversionSectionWrapperFactory.createSectionWrapper(ppr.getSectPr(), previousHF, rels, evenAndOddHeaders, ++conversionSectionIndex, sectionContent, dummyPageNumbering);
                    conversionSections.add(currentSectionWrapper);
                    previousHF = currentSectionWrapper.getHeaderFooterPolicy();
                    sectionContent = new ArrayList();
                }
            }
            sectionContent.add(o);
        }
        currentSectionWrapper = ConversionSectionWrapperFactory.createSectionWrapper(document.getBody().getSectPr(), previousHF, rels, evenAndOddHeaders, ++conversionSectionIndex, sectionContent, dummyPageNumbering);
        conversionSections.add(currentSectionWrapper);
        return conversionSections;
    }

    protected static ConversionSectionWrapper createSectionWrapper(SectPr sectPr, HeaderFooterPolicy headerFooterPolicy, RelationshipsPart rels, BooleanDefaultTrue evenAndOddHeaders, int conversionSectionIndex, List<Object> content, boolean dummyPageNumbering) {
        PageNumberInformation pageNumberInformation = null;
        ConversionSectionWrapper ret = new ConversionSectionWrapper(sectPr, headerFooterPolicy, rels, evenAndOddHeaders, "s" + Integer.toString(conversionSectionIndex), content);
        pageNumberInformation = PageNumberInformationCollector.process(ret, dummyPageNumbering);
        ret.setPageNumberInformation(pageNumberInformation);
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SdtBlockFinder
    extends TraversalUtil.CallbackImpl {
        List<SdtBlock> sdtBlocks = new ArrayList<SdtBlock>();
        LinkedList<SdtBlock> ll = new LinkedList();

        protected SdtBlockFinder() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof P && ((P)o).getPPr() != null && ((P)o).getPPr().getSectPr() != null) {
                for (SdtBlock sdt : this.ll) {
                    if (this.sdtBlocks.contains(sdt)) continue;
                    this.sdtBlocks.add(sdt);
                }
            }
            return null;
        }

        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    if ((o = XmlUtils.unwrap(o)) instanceof Child) {
                        if (parent instanceof SdtBlock) {
                            ((Child)o).setParent(((SdtBlock)parent).getSdtContent().getContent());
                        } else {
                            ((Child)o).setParent(parent);
                        }
                    }
                    this.apply(o);
                    if (o instanceof SdtBlock) {
                        this.ll.addLast((SdtBlock)o);
                    }
                    if (this.shouldTraverse(o)) {
                        this.walkJAXBElements(o);
                    }
                    if (!(o instanceof SdtBlock)) continue;
                    this.ll.removeLast();
                }
            }
        }
    }
}

