/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.formats;

import java.util.LinkedHashMap;

import org.docx4j.dml.CTTableCellProperties;
import org.docx4j.dml.STTextAnchoringType;
import org.docx4j.dml.STTextVerticalType;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner.TcBorders;
import org.docx4j.wml.TextDirection;


public class CellProperties {
	private BorderProperties borderBottom;
	private BorderProperties borderLeft;
	private BorderProperties borderTop;
	private BorderProperties borderRight;
	private String verticalAlign;
	private int paddingBottom;
	private int paddingTop;
	private int paddingLeft;
	private int paddingRight;
	private String backgroundColor;
	private String textDirection;
	
	public CellProperties(BorderProperties borderBottom,
			BorderProperties borderLeft, BorderProperties borderTop,
			BorderProperties borderRight, String verticalAlign,
			int paddingBottom, int paddingTop, int paddingLeft,
			int paddingRight, String backgroundColor, String textDirection) {
		super();
		this.borderBottom = borderBottom;
		this.borderLeft = borderLeft;
		this.borderTop = borderTop;
		this.borderRight = borderRight;
		this.verticalAlign = verticalAlign;
		this.paddingBottom = paddingBottom;
		this.paddingTop = paddingTop;
		this.paddingLeft = paddingLeft;
		this.paddingRight = paddingRight;
		this.backgroundColor = backgroundColor;
		this.textDirection = textDirection;
	}


	
	public String getVerticalAlign() {
		return verticalAlign;
	}
	public int getPaddingBottom() {
		return paddingBottom;
	}
	public int getPaddingTop() {
		return paddingTop;
	}
	public int getPaddingLeft() {
		return paddingLeft;
	}
	public int getPaddingRight() {
		return paddingRight;
	}
	public String getBackgroundColor() {
		return backgroundColor;
	}
	public void setBackgroundColor(String color) {
		backgroundColor = color;
	}


	public BorderProperties getBorderBottom() {
		return borderBottom;
	}

	public String getTextDirection() {
		return textDirection;
	}
	
	public void setTextDirection(String s) {
		textDirection = s;
	}


	public void setBorderBottom(BorderProperties borderBottom) {
//		if( Debug.debug ) System.err.println("{cellProperties}\tsetBorderBottom" );
		this.borderBottom = borderBottom;
	}



	public BorderProperties getBorderLeft() {
		return borderLeft;
	}



	public void setBorderLeft(BorderProperties borderLeft) {
//		if( Debug.debug ) System.err.println("{cellProperties}\tsetBorderLeft" );
		this.borderLeft = borderLeft;
	}



	public BorderProperties getBorderTop() {
		return borderTop;
	}



	public void setBorderTop(BorderProperties borderTop) {
//		if( Debug.debug ) System.err.println("{cellProperties}\tsetBorderTop" );
		this.borderTop = borderTop;
	}



	public BorderProperties getBorderRight() {
		return borderRight;
	}



	public void setBorderRight(BorderProperties borderRight) {
//		if( Debug.debug ) System.err.println("{cellProperties}\tsetBorderRight" );
		this.borderRight = borderRight;
	}

	public CellProperties getClone(){
		return( new CellProperties( borderBottom,
				 borderLeft,  borderTop,
				 borderRight,  verticalAlign,
				 paddingBottom,  paddingTop,  paddingLeft,
				 paddingRight,  backgroundColor, textDirection) );
	}
	
	public TcPr get_docx_cp() {
		TcPr tcPr = new TcPr();
		
		CTShd shd = new CTShd();
		shd.setFill(backgroundColor);
		tcPr.setShd(shd);
		
		if( textDirection.equals("tbrl") ){
			TextDirection td = new TextDirection();
			td.setVal("tbRl");
			tcPr.setTextDirection(td);
		} else if( textDirection.equals("btlr") ){
			TextDirection td = new TextDirection();
			td.setVal("btLr");
			tcPr.setTextDirection(td);
		}

		
		
		if( borderBottom.hasBorder() || borderLeft.hasBorder() || 
				borderRight.hasBorder() || borderTop.hasBorder() ){
			TcBorders tcb = new TcBorders();
			
			if( borderBottom.hasBorder() )
				tcb.setBottom(borderBottom.get_docx_bd());
			if( borderLeft.hasBorder() )
				tcb.setLeft(borderLeft.get_docx_bd());
			if( borderRight.hasBorder() )
				tcb.setRight(borderRight.get_docx_bd());
			if( borderTop.hasBorder() )
				tcb.setTop(borderTop.get_docx_bd());
		    tcPr.setTcBorders(tcb);
		}
	    CTVerticalJc valign = new CTVerticalJc();
	    if( verticalAlign.equals("center") )
	    	valign.setVal(STVerticalJc.CENTER);
	    else if( verticalAlign.equals("middle") )
	    	valign.setVal(STVerticalJc.CENTER);
	    else if( verticalAlign.equals("top") )
	    	valign.setVal(STVerticalJc.TOP);
	    else if( verticalAlign.equals("bottom") )
	    	valign.setVal(STVerticalJc.BOTTOM);
	    else valign.setVal(STVerticalJc.CENTER);
	    tcPr.setVAlign(valign);
		
	    if( paddingBottom > 0 || paddingTop > 0 || paddingLeft > 0 || paddingRight > 0 )
	    	tcPr.setTcMar(org.lysis.reporters.docx4r.tools.Format.getMargins(paddingBottom, paddingTop, paddingLeft, paddingRight) );
	    

	    return tcPr;
	}
	public CTTableCellProperties get_pptx_cp() throws Exception {
		CTTableCellProperties tcPr = new CTTableCellProperties();
		
		tcPr.setSolidFill(org.lysis.reporters.pptx4r.tools.Format.getCol(backgroundColor));
		tcPr.setLnB(borderBottom.get_pptx_bd("B"));
		tcPr.setLnT(borderTop.get_pptx_bd("T"));
		tcPr.setLnR(borderRight.get_pptx_bd("R"));
		tcPr.setLnL(borderLeft.get_pptx_bd("L"));

		if( textDirection.equals("tbrl") ){
			tcPr.setVert(STTextVerticalType.VERT);
		} else if( textDirection.equals("btlr") ){
			tcPr.setVert(STTextVerticalType.VERT_270);
		}
		
		
	    if( verticalAlign.equals("center") )
	    	tcPr.setAnchor(STTextAnchoringType.CTR);
	    else if( verticalAlign.equals("middle") )
	    	tcPr.setAnchor(STTextAnchoringType.CTR);
	    else if( verticalAlign.equals("top") )
	    	tcPr.setAnchor(STTextAnchoringType.T);
	    else if( verticalAlign.equals("bottom") )
	    	tcPr.setAnchor(STTextAnchoringType.B);
	    else tcPr.setAnchor(STTextAnchoringType.CTR);
	    tcPr.setMarB(new Integer(paddingBottom*12700));
	    tcPr.setMarT(new Integer(paddingTop*12700));
	    tcPr.setMarR(new Integer(paddingRight*12700));
	    tcPr.setMarL(new Integer(paddingLeft*12700));

	    return tcPr;
	}
	
	public LinkedHashMap<String, String> get_html_cp( )  {
		LinkedHashMap<String, String> tcPr = new LinkedHashMap<String, String>();

		tcPr.put("background-color", backgroundColor);	

		if( borderBottom.getBorderWidth() > 0 && !borderBottom.getBorderStyle().equals("none") ){
			tcPr.put("border-bottom-color", borderBottom.getBorderColor() );	
			tcPr.put("border-bottom-style", borderBottom.getBorderStyle() );	
			tcPr.put("border-bottom-width", borderBottom.getBorderWidth() + "px" );	
		}
		
		if( borderTop.getBorderWidth() > 0 && !borderTop.getBorderStyle().equals("none") ){
			tcPr.put("border-top-color", borderTop.getBorderColor() );	
			tcPr.put("border-top-style", borderTop.getBorderStyle() );	
			tcPr.put("border-top-width", borderTop.getBorderWidth() + "px" );
		}
		
		if( borderRight.getBorderWidth() > 0 && !borderRight.getBorderStyle().equals("none") ){
			tcPr.put("border-right-color", borderRight.getBorderColor() );	
			tcPr.put("border-right-style", borderRight.getBorderStyle() );
			tcPr.put("border-right-width", borderRight.getBorderWidth() + "px" );
		}
		
		if( borderLeft.getBorderWidth() > 0 && !borderLeft.getBorderStyle().equals("none") ){
			tcPr.put("border-left-color", borderLeft.getBorderColor() );	
			tcPr.put("border-left-style", borderLeft.getBorderStyle() );	
			tcPr.put("border-left-width", borderLeft.getBorderWidth() + "px" );	
		}
		
		if( verticalAlign.equals("center") )
			tcPr.put("vertical-align", "middle" );	
		else tcPr.put("vertical-align", verticalAlign );	
		
	
		tcPr.put("padding-left", paddingLeft + "pt" );	
		tcPr.put("padding-right", paddingRight + "pt" );	
		tcPr.put("padding-top", paddingTop + "pt" );	
		tcPr.put("padding-bottom", paddingBottom + "pt" );	

	    return tcPr;
	}
	
	public void print( )  {

		System.out.println("background-color:" + backgroundColor + ";");	

		System.out.println("border-bottom-color:" + borderBottom.getBorderColor() + ";" );	
		System.out.println("border-bottom-style:" + borderBottom.getBorderStyle() + ";" );	
		System.out.println("border-bottom-width:" + borderBottom.getBorderWidth() + "px" + ";" );	
		System.out.println("border-top-color:" + borderTop.getBorderColor()  + ";");	
		System.out.println("border-top-style:" + borderTop.getBorderStyle() );	
		System.out.println("border-top-width:" + borderTop.getBorderWidth() + "px" + ";" );	
		System.out.println("border-right-color:" + borderRight.getBorderColor() + ";" );	
		System.out.println("border-right-style:" + borderRight.getBorderStyle() );	
		System.out.println("border-right-width:" + borderRight.getBorderWidth() + "px" + ";" );	
		System.out.println("border-left-color:" + borderLeft.getBorderColor() + ";" );	
		System.out.println("border-left-style:" + borderLeft.getBorderStyle()  + ";");	
		System.out.println("border-left-width:" + borderLeft.getBorderWidth() + "px" + ";" );	

		if( verticalAlign.equals("center") )
			System.out.println("vertical-align:" + "middle" + ";" );	
		else System.out.println("vertical-align:" + verticalAlign + ";" );	
		
	
		System.out.println("padding-left:" + paddingLeft + "px" + ";" );	
		System.out.println("padding-right:" + paddingRight + "px" + ";" );	
		System.out.println("padding-top:" + paddingTop + "px" + ";" );	
		System.out.println("padding-bottom:" + paddingBottom + "px" + ";" );	

	}
	
}
