% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/text_extract.R
\name{text_extract}
\alias{text_extract}
\title{Simple Text Extraction From a Word Document}
\usage{
text_extract(x, body = TRUE, header = TRUE, footer = TRUE, bookmark)
}
\arguments{
\item{x}{\code{\link{docx}} object}

\item{body}{specifies to scan document body}

\item{header}{specifies to scan document header}

\item{footer}{specifies to scan document footer}

\item{bookmark}{a character value ; id of the Word bookmark to scan.}
}
\value{
a character vector
}
\description{
Provides a simple method to get text from a docx document.
It returns a \code{character} vector containing all
chunk of text found in the document.
}
\examples{
\dontrun{
doc = docx( title = "My example", template = file.path( 
  find.package("ReporteRs"), "templates/bookmark_example.docx") )
text_extract( doc )
text_extract( doc, header = FALSE, footer = FALSE )
text_extract( doc, bookmark = "author" )
}
}
\seealso{
\code{\link{docx}}, \code{\link{list_bookmarks}}
}

