/*
 * This file is part of ReporteRs.
 * Copyright (c) 2014, David Gohel All rights reserved.
 *
 * ReporteRs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ReporteRs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ReporteRs.  If not, see <http://www.gnu.org/licenses/>.
**/

#include <stdio.h>
#include <Rinternals.h>
#include <R.h>

#include <R_ext/GraphicsEngine.h>
#include <R_ext/GraphicsDevice.h>

extern "C" {
	void get_current_canvas_id(int *dn, int *res);
	void get_current_element_id(int *dn, int *res);

	void set_tracer_on(int *dn);
	void set_tracer_off(int *dn);
	void collect_id(int *dn, int *res);

	void add_popup(int *dn, int *id, char **str, int *l);
	void add_click(int *dn, int *id, char **str, int *l);
	void add_dblclick(int *dn, int *id, char **str, int *l);
	void add_post_commands( int *dn, int *id, char **str, int *l);
	void trigger_last_post_commands( int *dn );
}
