/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.formats;

import java.math.BigInteger;
import java.util.LinkedHashMap;

import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.CTTextSpacing;
import org.docx4j.dml.CTTextSpacingPoint;
import org.docx4j.dml.STTextAlignType;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;

public class ParProperties {
	private String textalign;
	private int paddingbottom;
	private int paddingtop;
	private int paddingleft;
	private int paddingright;

	public String getTextalign() {
		return textalign;
	}

	public int getPaddingbottom() {
		return paddingbottom;
	}

	public int getPaddingtop() {
		return paddingtop;
	}

	public int getPaddingleft() {
		return paddingleft;
	}

	public int getPaddingright() {
		return paddingright;
	}

	public ParProperties(String textalign, int paddingbottom, int paddingtop,
			int paddingleft, int paddingright) {
		super();
		this.textalign = textalign;
		this.paddingbottom = paddingbottom;
		this.paddingtop = paddingtop;
		this.paddingleft = paddingleft;
		this.paddingright = paddingright;
	}
	
	public PPr get_docx_pp(){
		PPr parProperties = new PPr();
		
		Jc alignment = new Jc();
		if( textalign.equals("left")) alignment.setVal(JcEnumeration.LEFT);
		else if( textalign.equals("center")) alignment.setVal(JcEnumeration.CENTER);
		else if( textalign.equals("right")) alignment.setVal(JcEnumeration.RIGHT);
		else if( textalign.equals("justify")) alignment.setVal(JcEnumeration.BOTH);
        parProperties.setJc(alignment); 
        PPrBase.Spacing space = new PPrBase.Spacing();
        space.setBefore(BigInteger.valueOf((long)paddingtop*20));
        space.setAfter(BigInteger.valueOf((long)paddingbottom*20));
        parProperties.setSpacing(space);
        
        PPrBase.Ind padding = new PPrBase.Ind();
        padding.setLeft(BigInteger.valueOf((long)paddingleft*20));
        padding.setRight(BigInteger.valueOf((long)paddingright*20));
        parProperties.setInd(padding);

        return parProperties;

	}

	public CTTextParagraphProperties get_pptx_pp(){
		CTTextParagraphProperties parProperties = new CTTextParagraphProperties();
		
		if( textalign.equals("left")) parProperties.setAlgn(STTextAlignType.L);
		else if( textalign.equals("center")) parProperties.setAlgn(STTextAlignType.CTR);
		else if( textalign.equals("right")) parProperties.setAlgn(STTextAlignType.R);
		else if( textalign.equals("justify")) parProperties.setAlgn(STTextAlignType.JUST);

		CTTextSpacing spaceafter = new CTTextSpacing();
		CTTextSpacingPoint pointafter = new CTTextSpacingPoint();
		pointafter.setVal(paddingbottom*100);
		spaceafter.setSpcPts(pointafter);
		parProperties.setSpcAft(spaceafter);

		CTTextSpacing spacebefore = new CTTextSpacing();
		CTTextSpacingPoint pointbefore = new CTTextSpacingPoint();
		pointbefore.setVal(paddingtop*100);
		spacebefore.setSpcPts(pointbefore);
		parProperties.setSpcBef(spacebefore);
		

		parProperties.setMarL(paddingleft*12700);
		parProperties.setMarR(paddingleft*12700);
              
        return parProperties;

	}
	
	public LinkedHashMap<String, String> get_html_pp() {
		LinkedHashMap<String, String> parProperties = new LinkedHashMap<String, String>();


		if( textalign.equals("left")) parProperties.put("text-align", "left");	
		else if( textalign.equals("center")) parProperties.put("text-align", "center");	
		else if( textalign.equals("right")) parProperties.put("text-align", "right");	
		else if( textalign.equals("justify")) parProperties.put("text-align", "justify");	
		else parProperties.put("text-align", "left");
		
		parProperties.put("margin-top", paddingtop+"px");	
		parProperties.put("margin-bottom", paddingbottom+"px");	
		parProperties.put("margin-right", paddingright+"px");	
		parProperties.put("margin-left", paddingleft+"px");	
 

        return parProperties;

	}
}
