/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.text;

import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.html4r.tools.utils;
import org.lysis.reporters.pptx4r.elements.Utils;
import org.lysis.reporters.tools.HTML4R;

public class Paragraph
implements HTML4R {
    private LinkedHashMap<Integer, String> textList = new LinkedHashMap();
    private LinkedHashMap<Integer, TextProperties> formatList = new LinkedHashMap();
    private int index = 0;
    private boolean hasBookmark;
    private JAXBElement<CTBookmark> bmStart;
    private JAXBElement<CTMarkupRange> bmEnd;
    private boolean vanilla_format = false;

    public void setVanilla() {
        this.vanilla_format = true;
    }

    public void setBookmark(String bookmark, BigInteger bookmarkID) {
        this.hasBookmark = true;
        ObjectFactory factory = Context.getWmlObjectFactory();
        CTBookmark bm = new CTBookmark();
        bm.setId(bookmarkID);
        bm.setName(bookmark);
        this.bmStart = factory.createBodyBookmarkStart(bm);
        CTMarkupRange mr = factory.createCTMarkupRange();
        mr.setId(bookmarkID);
        this.bmEnd = factory.createBodyBookmarkEnd(mr);
    }

    public void addText(String value, TextProperties tp) throws IOException {
        ++this.index;
        this.textList.put(this.index, value);
        this.formatList.put(this.index, tp);
    }

    public void addText(String value) throws IOException {
        ++this.index;
        this.textList.put(this.index, value);
        this.formatList.put(this.index, null);
    }

    public void addParagraph(Paragraph value) throws IOException {
        value = Paragraph.reindex(value, this.index);
        this.textList.putAll(value.textList);
        this.formatList.putAll(value.formatList);
        this.index += value.index;
    }

    private static Paragraph reindex(Paragraph value, int add) {
        if (value.index < 1) {
            return value;
        }
        LinkedHashMap<Integer, String> newTextList = new LinkedHashMap<Integer, String>();
        LinkedHashMap<Integer, TextProperties> newFormatList = new LinkedHashMap<Integer, TextProperties>();
        int i = 1;
        while (i <= value.index) {
            newTextList.put(i + add, value.textList.get(i));
            newFormatList.put(i + add, value.formatList.get(i));
            ++i;
        }
        value.textList = newTextList;
        value.formatList = newFormatList;
        return value;
    }

    public void setTextProperties(TextProperties tp) {
        for (int key : this.formatList.keySet()) {
            this.formatList.put(key, tp);
        }
    }

    public String toString() {
        String out = "";
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                out = String.valueOf(out) + this.textList.get(i);
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        String out = "";
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                if (this.formatList.get(i) != null) {
                    TextProperties tp = this.formatList.get(i);
                    String css = this.vanilla_format ? Format.getJSString(tp.get_html_pr_vanilla()) : Format.getJSString(tp.get_html_pr());
                    out = String.valueOf(out) + utils.span_style(this.textList.get(i), css);
                } else {
                    out = String.valueOf(out) + utils.span(this.textList.get(i));
                }
                ++i;
            }
        }
        return out;
    }

    public P get_docx_par() {
        P p = new P();
        this.fill_docx_par(p);
        return p;
    }

    public P get_docx_par(WordprocessingMLPackage doc, String style) {
        P p = doc.getMainDocumentPart().createStyledParagraphOfText(style, "");
        this.fill_docx_par(p);
        return p;
    }

    private void fill_docx_par(P p) {
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                if (this.formatList.get(i) != null) {
                    TextProperties tp = this.formatList.get(i);
                    R run = new R();
                    Text text = new Text();
                    text.setValue(this.textList.get(i));
                    text.setSpace("preserve");
                    run.getContent().add(text);
                    RPr rpr = tp.get_docx_pr();
                    run.setRPr(rpr);
                    p.getContent().add(run);
                } else {
                    R run = new R();
                    Text text = new Text();
                    text.setValue(this.textList.get(i));
                    text.setSpace("preserve");
                    run.getContent().add(text);
                    p.getContent().add(run);
                }
                if (this.hasBookmark) {
                    p.getContent().add(0, this.bmStart);
                    p.getContent().add(1, this.bmEnd);
                }
                ++i;
            }
        }
    }

    public CTTextParagraph get_pptx_par() throws Exception {
        CTTextParagraph textPar = new CTTextParagraph();
        if (this.index > 0) {
            List runs = textPar.getEGTextRun();
            int i = 1;
            while (i <= this.index) {
                if (this.formatList.get(i) != null) {
                    TextProperties tp = this.formatList.get(i);
                    CTTextCharacterProperties rpr = tp.get_pptx_pr();
                    CTRegularTextRun textRun = Utils.getRun(this.textList.get(i));
                    textRun.setRPr(rpr);
                    runs.add(textRun);
                } else {
                    CTRegularTextRun textRun = Utils.getRun(this.textList.get(i));
                    runs.add(textRun);
                }
                ++i;
            }
        }
        return textPar;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

