% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectSizeReplicationSuccess.R
\name{effectSizeReplicationSuccess}
\alias{effectSizeReplicationSuccess}
\title{Computes the minimum relative effect size to achieve replication success}
\usage{
effectSizeReplicationSuccess(
  zo,
  c = 1,
  level = 0.025,
  alternative = c("one.sided", "two.sided"),
  type = c("golden", "nominal", "liberal", "controlled")
)
}
\arguments{
\item{zo}{Numeric vector of z-values from original studies.}

\item{c}{Numeric vector of variance ratios of the original and replication effect estimates.
This is usually the ratio of the sample size of the replication study to the sample
size of the original study.}

\item{level}{Replication success level. Default is 0.025.}

\item{alternative}{Specifies if the replication success level is "one.sided" (default) or "two.sided".
If the replication success level is one-sided, then effect size calculations are based on a one-sided assessment of
replication success in the direction of the original effect estimate.}

\item{type}{Type of recalibration. Can be either "golden" (default), "nominal" (no recalibration),
"liberal", or "controlled". "golden" ensures that for an original study just significant at
the specified \code{level}, replication success is only possible for replication effect estimates larger than the original one.
See \code{\link{levelSceptical}} for details about recalibration types.}
}
\value{
The minimum relative effect size to achieve replication success.
}
\description{
The minimum relative effect size (replication to original) to achieve replication success
is computed based on the result of the original study and the corresponding variance ratio.
}
\details{
\code{effectSizeReplicationSuccess} is the vectorized version of \code{.effectSizeReplicationSuccess_}.
\code{\link[base]{Vectorize}} is used to vectorize the function.
}
\examples{
po <- c(0.001, 0.002, 0.01, 0.02, 0.025)
zo <- p2z(po, alternative = "one.sided")

effectSizeReplicationSuccess(zo = zo, c = 1, level = 0.025,
                             alternative = "one.sided", type = "golden")
                             
effectSizeReplicationSuccess(zo = zo, c = 10, level = 0.025,
                             alternative = "one.sided", type = "golden")
                             
effectSizeReplicationSuccess(zo = zo, c= 2, level = 0.025,
                             alternative = "one.sided", type = "nominal")
                             
effectSizeReplicationSuccess(zo = zo, c = 2, level = 0.05,
                             alternative = "two.sided", type = "nominal")
}
\references{
Held, L., Micheloud, C., Pawel, S. (2021). The assessment of replication
success based on relative effect size. \url{https://arxiv.org/abs/2009.07782}
}
\seealso{
\code{\link{sampleSizeReplicationSuccess}}, \code{\link{levelSceptical}}
}
\author{
Leonhard Held, Charlotte Micheloud, Samuel Pawel, Florian Gerber
}
