% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleExperience.R
\name{sampleExperience}
\alias{sampleExperience}
\title{Sample state transitions from an environment function}
\usage{
sampleExperience(N, env, states, actions, actionSelection = "random",
  control = list(alpha = 0.1, gamma = 0.1, epsilon = 0.1), model = NULL,
  ...)
}
\arguments{
\item{N}{Number of samples.}

\item{env}{An environment function.}

\item{states}{A character vector defining the enviroment states.}

\item{actions}{A character vector defining the available actions.}

\item{actionSelection}{(optional) Defines the action selection mode of the reinforcement learning agent. Default: \code{random}.}

\item{control}{(optional) Control parameters defining the behavior of the agent.
Default: \code{alpha = 0.1}; \code{gamma = 0.1}; \code{epsilon = 0.1}.}

\item{model}{(optional) Existing model of class \code{rl}. Default: \code{NULL}.}

\item{...}{Additional parameters passed to function.}
}
\value{
An \code{dataframe} containing the experienced state transition tuples \code{s,a,r,s_new}.
The individual columns are as follows:
\describe{
  \item{\code{State}}{The current state.}
  \item{\code{Action}}{The selected action for the current state.}
  \item{\code{Reward}}{The reward in the current state.}
  \item{\code{NextState}}{The next state.}
}
}
\description{
Function generates sample experience in the form of state transition tuples.
}
\examples{
# Define environment
env <- gridworldEnvironment

# Define states and actions
states <- c("s1", "s2", "s3", "s4")
actions <- c("up", "down", "left", "right")

# Sample 1000 training examples
data <- sampleExperience(N = 1000, env = env, states = states, actions = actions)
}
\seealso{
\code{\link{ReinforcementLearning}}

\code{\link{gridworldEnvironment}}
}
