% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structuredSCA.R
\name{structuredSCA}
\alias{structuredSCA}
\title{Variable selection algorithm with a predefined component loading structure.}
\usage{
structuredSCA(DATA, Jk, R, Target, Position, LASSO, MaxIter, NRSTARTS)
}
\arguments{
\item{DATA}{A matrix, which contains the concatenated data with the same subjects from multiple blocks.}

\item{Jk}{A vector containing number of variables in the concatinated data matrix.}

\item{R}{Number of components (R>=2).}

\item{Target}{A matrix containing 0's and 1's. Its number of columns equals to R, and its number of rows equals to the number of blocks to be integrated. Thus, if the element in}

\item{Position}{Indicate on which component(s) the Lasso Penalty is imposed. If unspecified, the algorithm assume that the 
Lasso penalty is imposed on the common component(s) only. If there is no common component, then Lasso penalty is applied to all components.}

\item{LASSO}{A Lasso tuning parameter.}

\item{MaxIter}{The maximum rounds of iterations. It should be a positive integer. The default value is 400.}

\item{NRSTARTS}{Multi-start procedure: The number of multi-starts. The default value is 20.}
}
\value{
\item{Pmatrix}{The best estimated component loading matrix (i.e., P), if multi-starts >= 2.}
\item{Tmatrix}{The best estimated component score matrix (i.e., T), if multi-starts >= 2.}
\item{Lossvec}{A list of vectors containing the loss in each iteration for each multi-start.}
}
\description{
Variable selection algorithm when the common/distinctive structure is known a priori.
The common component can also be sparse, which is to be estimated by Lasso.
The distinctive components are not sparse in the sense that the entire variables in a component (belonging to a certain block) are either all zeros or non-zeros.
}
\examples{
\dontrun{
DATA1 <- matrix(rnorm(50), nrow=5)
DATA2 <- matrix(rnorm(100), nrow=5) 
DATA <- cbind(DATA1, DATA2)
Jk <- c(10, 20) 
R <- 5 
Target <- matrix(c(1,1,1,0,1,0,0,1,0,1), 2, 5) 
LASSO <- 0.2 
MaxIter <- 400
NRSTARTS <- 5
structuredSCA(DATA, Jk, R, Target, LASSO = LASSO)
}
}
\references{
Gu, Z., & Van Deun, K. (2016). A variable selection method for simultaneous component based data integration. \emph{Chemometrics and Intelligent Laboratory Systems}, 158, 187-199.
}
