% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series_uncor.R
\name{series_uncor}
\alias{series_uncor}
\title{Subset of Uncorrelated Series}
\usage{
series_uncor(
  X,
  return.value = c("series", "indexes"),
  type = c("adjacent", "all"),
  first.last = TRUE,
  m = 1,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{X}{A numeric matrix (or data frame) where the uncorrelated vectors 
are extracted from.}

\item{return.value}{A character string indicating the return of the function,
\code{"series"} for a matrix with uncorrelated columns or \code{"indexes"}
for a vector with the position of the uncorrelated columns in \code{X}.}

\item{type}{A character string indicating the type of uncorrelation wanted
between the extracted series (or columns), \code{"adjacent"} or 
\code{"all"} (see Details).}

\item{first.last}{Logical. Indicates if the first and last columns have also
to be uncorrelated (when \code{type = "adjacent"}).}

\item{m}{Integer value giving the starting column.}

\item{alpha}{Numeric value in \eqn{(0,1)}. It gives the significance level 
of the correlation test where alternative hypothesis is that the true 
correlation is not equal to 0.}

\item{...}{Further arguments to be passed to \code{\link[stats]{cor.test}} 
function (see \code{\link[stats]{cor.test}} for possible arguments).}
}
\value{
A matrix or a vector as specified by \code{return.value}.
}
\description{
Given a matrix this function extracts a subset of uncorrelated
  columns (see Details).
}
\details{
This function is used in the data preparation (or pre-processing) 
  often required to apply the exploratory and inference tools based on 
  theory of records within this package.

  Given a matrix \code{X} considered as a set of \eqn{M^*} vectors, which
  are the columns of \code{X}, this function extracts the biggest subset 
  of uncorrelated vectors (columns), using the following procedure: starting
  from column \code{m}, the test \code{\link[stats]{cor.test}} is applied to
  study the correlation between columns depending on argument \code{type}.
  
  If \code{type = "adjacent"}, the test is computed between \code{m}
  and \eqn{\code{m} + 1, \code{m} + 2, \ldots} and so on up to find a column 
  \eqn{\code{m} + k} which is not significantly correlated with column 
  \code{m}. Then, the process is repeated starting at column 
  \eqn{\code{m} + k}. All columns are checked. 
  
  When the first and last columns may not have a significant correlation, 
  where \code{m} is the first column, the parameter \code{first.last} should
  be \code{FALSE}. When the first and last columns could be correlated, 
  the function requires \code{first.last = TRUE}.
  
  If \code{type = "all"}, the procedure is similar as above but the new kept
  column cannot be significant correlated with any other column already 
  kept, not only the previous one. So this option results in a fewer number
  of columns.
}
\examples{
# Split Zaragoza series
TxZ <- series_split(TX_Zaragoza$TX)

# Index of uncorrelated columns depending on the criteria
series_uncor(TxZ, return.value = "indexes", type = "adjacent")
series_uncor(TxZ, return.value = "indexes", type = "all")

# Return the set of uncorrelated vectors
ZaragozaSeries <- series_uncor(TxZ)

}
\references{
Cebrián A, Castillo-Mateo J, Asín J (2021).
“Record Tests to Detect Non Stationarity in the Tails with an Application to Climate Change.”
Available at Research Square \doi{10.21203/rs.3.rs-214787/v1}
}
\seealso{
\code{\link{series_double}}, \code{\link{series_record}},
  \code{\link{series_rev}}, \code{\link{series_split}},
  \code{\link{series_ties}}, \code{\link{series_untie}}
}
\author{
Jorge Castillo-Mateo
}
