% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brown.method.R
\name{brown.method}
\alias{brown.method}
\title{Brown's Method on the Number of Records}
\usage{
brown.method(
  X,
  weights = function(t) 1,
  record = c(FU = 1, FL = 1, BU = 1, BL = 1),
  alternative = c(FU = "greater", FL = "less", BU = "less", BL = "greater"),
  correct = TRUE
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series,
e.g., if \code{function(t) t-1} then \eqn{\omega_t = t-1}.}

\item{record}{Logical vector. Vector with four elements indicating if the 
p-value of the test for forward upper, forward lower, backward upper and
backward lower are going to be used, respectively. Logical values or 0,1 
values are accepted.}

\item{alternative}{Vector with four character string taking values 
\code{"greater"} or \code{"less"} indicating the alternative hypothesis 
in every test (for forward upper, forward lower, backward upper and 
backward lower records , respectively). Under the alternative hypothesis 
of linear trend the FU and BL records will be greater and the FL and BU
records will be less than under the null, but other combinations (e.g., 
for trend in variability) could be considered.}

\item{correct}{Logical. Indicates, whether a continuity correction 
should be applied in \code{\link{N.test}}; defaults to \code{TRUE}.}
}
\value{
A \code{"htest"} object with elements:
  \item{statistic}{Value of the chi-square statistic (not scaled).}
  \item{parameter}{Degrees of freedom \eqn{df} and scale parameter \eqn{c}.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
Performs Brown's method on the p-values of \code{\link{N.test}}
  as proposed by Cebrián, Castillo-Mateo and Asín (2021). The null 
  hypothesis of the classical record model (i.e., of randomness) is tested
  against the alternative hypothesis.
}
\details{
In this function, the test is implemented as given by Cebrián, 
  Castillo-Mateo and Asín (2021), where the
  p-values \eqn{p^{(FU)}}, \eqn{p^{(FL)}}, \eqn{p^{(BU)}} and \eqn{p^{(BL)}}
  of the test \code{\link{N.test}} for the four types of record are used for
  the statistic:
  \deqn{-2 \left(\log(p^{(FU)}) + \log(p^{(FL)}) + \log(p^{(BU)}) + \log(p^{(BL)})\right).}
  (Any other combination of p-values for the test is also allowed.)
  
  According to Brown's method (Brown, 1975) for the union of dependent 
  p-values, the statistic follows a \eqn{c \chi^2_{df}} distribution, 
  with a scale parameter \eqn{c} and \eqn{df} degrees of freedom that 
  depend on the covariance of the p-values. This covariances are 
  approximated according to Kost and McDermott (2002):
  \deqn{\textrm{COV}\left(-2 \log(p^{(i)}), -2 \log(p^{(j)})\right) \approx 3.263 \rho_{ij} + 0.710 \rho_{ij}^2 + 0.027 \rho_{ij}^3,}
  where \eqn{\rho_{ij}} is the correlation between their respective 
  statistics.
  
  Power studies indicate that this and \code{\link{foster.test}} using all
  four types of records and linear weights are the two most powerful records
  tests against a linear drift model. In particular, this is more powerful 
  than Mann-Kendall test against alternatives with linear drift in series of
  generalized Pareto variables and some cases of the generalized extreme 
  value variables. See Cebrián, Castillo-Mateo and Asín (2021) for more 
  details.
}
\examples{
brown.method(ZaragozaSeries)
brown.method(ZaragozaSeries, weights = function(t) t-1)
brown.method(ZaragozaSeries, weights = function(t) t-1, correct = FALSE)

# Join p-values of upper records
brown.method(ZaragozaSeries, weights = function(t) t-1, record = c(1,0,1,0))
# Join p-values of lower records
brown.method(ZaragozaSeries, weights = function(t) t-1, record = c(0,1,0,1))

}
\references{
Brown M (1975). “A Method for Combining Non-Independent, One-Sided Tests of Significance.” 
\emph{Biometrics}. \strong{31}(4), 987–992. 

Cebrián A, Castillo-Mateo J, Asín J (2021).
“Record Tests to detect non stationarity in the tails with an application to climate change.”
Unpublished manuscript.

Kost JT, McDermott MP (2002). “Combining Dependent P-Values.”
\emph{Statistics & Probability Letters}, \strong{60}(2), 183-190.
}
\seealso{
\code{\link{fisher.method}}, \code{\link{foster.test}}, 
  \code{\link{N.test}}
}
\author{
Jorge Castillo-Mateo
}
