% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P_exactPB.test.R
\name{P_exactPB.test}
\alias{P_exactPB.test}
\alias{N_exactPB.test}
\title{Exact Poisson binomial test on record probabilities}
\usage{
P_exactPB.test(
  XM_T,
  record = c("upper", "lower"),
  method = c("mixed 1", "mixed 2", "dft", "butler")
)

N_exactPB.test(
  XM_T,
  record = c("upper", "lower"),
  method = c("mixed 1", "mixed 2", "dft", "butler")
)
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record to be 
calculated, "upper" or "lower".}

\item{method}{A character string that indicates the method by which the cdf
of the Poisson-Binomial distribution is calculated and therefore the 
p-value. \code{mixed 1} is the preferred (and default) method, it is a 
more efficient combination of the other algorithms. \code{mixed 2} is a 
less efficient version of \code{mixed 1}. \code{dft} uses the discrete 
Fourier transform which algorithm is given in Hong (2013). \code{butler}
use the algorithm given by Butler and Stephens (2016).}
}
\value{
A \code{"htest"} object with elements:
  \item{statistic}{Value of the likelihood ratio statistic.}
  \item{parameter}{Length \eqn{T} of the probability vector
    \eqn{(p_2,\ldots,p_T)} and number \eqn{M} of Poisson-Binomial i.i.d. 
    variables summed with the same probability vector in the statistic.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
This function performs an exact test based on the record 
  probabiliteis \eqn{p_t} to study the hypothesis of the classical record 
  model.
}
\details{
The null hypothesis of this likelihood ratio test is that in all 
  the vectors (columns of matrix \code{XM_T}), the probability of record 
  at time \eqn{t} is \eqn{1/t}. The test statistic is the  total number of 
  records at times \eqn{t=2, ..., T}, in the \eqn{M} vectors. Under the 
  null, this is the sum of \eqn{(T-1)M} independent Bernoulli variables,
  with probabilities \eqn{p_2,\ldots,p_2,\ldots,p_T,\ldots,p_T} with 
  \eqn{p_t=1/t}, so that its distribution is a Poisson-Binomial.

  Only unilateral alternative hypotehesis \eqn{p_t > 1/t, t=2,\ldots,T}  
  or \eqn{p_t <1/t, t=2,\ldots,T} are valid, since otherwise the statistic
  is not able to detect deviations from the null hypothesis.

  \code{\link{N_exactPB.test}} is the same test, but applied to only one 
  vector, instead of \eqn{M}. Note in this case this test considers the 
  probability at time \eqn{t=1} (by definition of \eqn{N_t}), but the 
  p-value is the same.
}
\examples{
P_exactPB.test(ZaragozaSeries)
N_exactPB.test(ZaragozaSeries[, 23])
}
\references{
Butler, K. and Stephens, M.A. (2016).
The Distribution of a Sum of Independent Binomial Random Variables.
\emph{Methodology and Computing in Applied Probability}, \strong{19}(2), 557-571.
doi:\href{https://doi.org/10.1007/s11009-016-9533-4}{10.1007/s11009-016-9533-4}

Hong, Y. (2013). 
On computing the distribution function for the Poisson binomial distribution.
\emph{Computational Statistics & Data Analysis}, \strong{59}, 41-51.
doi:\href{https://doi.org/10.1016/j.csda.2012.10.006}{10.1016/j.csda.2012.10.006}
}
\seealso{
\code{\link{P_chisq.test}}, \code{\link{P_regression.test}}
}
\author{
Jorge Castillo-Mateo
}
