/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public final class OSGiLocator {
    private static Map<String, List<Callable<Class<?>>>> factories;

    private OSGiLocator() {
    }

    public static synchronized void unregister(String serviceName, Callable<Class<?>> factory) {
        List<Callable<Class<?>>> l;
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        if (factories != null && (l = factories.get(serviceName)) != null) {
            l.remove(factory);
        }
    }

    public static synchronized void register(String serviceName, Callable<Class<?>> factory) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        if (factory != null) {
            List<Callable<Class<?>>> l;
            if (factories == null) {
                factories = new HashMap();
            }
            if ((l = factories.get(serviceName)) == null) {
                l = new ArrayList();
                factories.put(serviceName, l);
            }
            l.add(factory);
        }
    }

    public static synchronized Class<?> locate(String serviceName) {
        List<Callable<Class<?>>> l;
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        if (factories != null && (l = factories.get(serviceName)) != null && !l.isEmpty()) {
            Callable<Class<?>> c = l.get(l.size() - 1);
            try {
                return c.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized List<Class<?>> locateAll(String serviceName) {
        List<Callable<Class<?>>> l;
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        ArrayList classes = new ArrayList();
        if (factories != null && (l = factories.get(serviceName)) != null) {
            for (Callable<Class<?>> c : l) {
                try {
                    classes.add(c.call());
                }
                catch (Exception exception) {}
            }
        }
        return classes;
    }
}

