/*
 * Decompiled with CFR 0.152.
 */
package org.math.r.drools;

import com.Ostermiller.util.CSVParser;
import com.Ostermiller.util.CSVPrinter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.NullArgumentException;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatelessSession;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderErrors;

public class DroolsService {
    private String[] inputColumns = null;
    private List<String> expectedInputColumns = new ArrayList<String>();
    private List<String> outputColumns = new ArrayList<String>();
    private StatelessSession session = null;

    public DroolsService(String rules, String expectedInputColumnsCSV, String outputColumnsCSV) throws Exception {
        this.validateInputs(rules, expectedInputColumnsCSV, this.expectedInputColumns, outputColumnsCSV, this.outputColumns);
        this.session = this.createSession(rules);
    }

    public String execute(String inputCSV) throws Exception {
        String outputCSV = null;
        ByteArrayOutputStream csvOutputStream = new ByteArrayOutputStream();
        this.validateInputCSV(inputCSV);
        ByteArrayInputStream inputCSVStream = new ByteArrayInputStream(inputCSV.getBytes());
        CSVParser parser = new CSVParser((InputStream)inputCSVStream);
        this.inputColumns = parser.getLine();
        this.verifyInputColumns(this.expectedInputColumns, this.inputColumns);
        CSVPrinter printer = new CSVPrinter((OutputStream)csvOutputStream);
        printer.writeln(this.outputColumns.toArray(new String[this.outputColumns.size()]));
        this.runRules(this.inputColumns, this.outputColumns, parser, printer, this.session);
        outputCSV = new String(csvOutputStream.toByteArray(), "UTF-8");
        return outputCSV;
    }

    protected void validateInputCSV(String inputCSV) throws Exception {
        if (inputCSV == null || inputCSV == "") {
            throw new NullArgumentException("The input dataset is emtpy!");
        }
    }

    protected void validateInputs(String rules, String expectedInputColumnsCSV, List<String> expectedInputColumns, String outputColumnsCSV, List<String> outputColumns) throws Exception {
        if (rules == null || rules == "") {
            throw new NullArgumentException("Empty rules file!");
        }
        StringTokenizer tokenizer = null;
        if (expectedInputColumnsCSV != null && expectedInputColumnsCSV != "") {
            tokenizer = new StringTokenizer(expectedInputColumnsCSV.replace(" ", ""), ",");
            while (tokenizer.hasMoreTokens()) {
                expectedInputColumns.add(tokenizer.nextToken());
            }
        } else {
            throw new NullArgumentException("No input columns found!");
        }
        if (expectedInputColumnsCSV != null && expectedInputColumnsCSV != "") {
            tokenizer = new StringTokenizer(outputColumnsCSV.replace(" ", ""), ",");
            while (tokenizer.hasMoreTokens()) {
                outputColumns.add(tokenizer.nextToken());
            }
        } else {
            throw new NullArgumentException("No output columns found!");
        }
    }

    protected void verifyInputColumns(List<String> expectedInputColumns, String[] inputColumns) throws Exception {
        for (String column : expectedInputColumns) {
            boolean found = false;
            for (int index = 0; index < inputColumns.length; ++index) {
                if (!inputColumns[index].equals(column)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Error: The input CSV file does not contain the column '" + column + "' which is required by the rules file!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatelessSession createSession(String rules) throws Exception {
        ByteArrayInputStream rulesStream = new ByteArrayInputStream(rules.getBytes());
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(rulesStream));
            PackageBuilderErrors errors = builder.getErrors();
            if (errors != null && errors.getErrors() != null && errors.getErrors().length > 0) {
                StringBuilder b = new StringBuilder();
                b.append("Error parsing rules file:\r\n");
                for (DroolsError error : errors.getErrors()) {
                    b.append(error).append("\r\n");
                }
                throw new IllegalArgumentException(b.toString());
            }
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(builder.getPackage());
            StatelessSession statelessSession = ruleBase.newStatelessSession();
            return statelessSession;
        }
        finally {
            if (rulesStream != null) {
                try {
                    ((InputStream)rulesStream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void runRules(String[] inputColumns, List<String> outputColumns, CSVParser parser, CSVPrinter printer, StatelessSession session) throws Exception {
        String[] inputRow;
        String[] outputRow = new String[outputColumns.size()];
        HashMap<String, String> inputMap = new HashMap<String, String>();
        HashMap outputMap = new HashMap();
        session.setGlobal("output", outputMap);
        while ((inputRow = parser.getLine()) != null) {
            int index;
            for (index = 0; index < inputColumns.length; ++index) {
                inputMap.put(inputColumns[index], inputRow[index]);
            }
            if (outputMap.size() > 0) {
                outputMap.clear();
            }
            session.execute(inputMap);
            if (outputMap.size() <= 0) continue;
            for (index = 0; index < outputColumns.size(); ++index) {
                outputRow[index] = (String)outputMap.get(outputColumns.get(index));
            }
            printer.writeln(outputRow);
        }
    }
}

