% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoDistSamp.R
\name{autoDistSamp}
\alias{autoDistSamp}
\title{Automated classical distance analysis}
\usage{
autoDistSamp(formula, detectionData, siteData, w.lo = 0, w.hi = NULL,
  likelihoods = c("halfnorm", "hazrate", "uniform", "negexp", "Gamma"),
  series = c("cosine", "hermite", "simple"), expansions = 0:3,
  pointSurvey = FALSE, warn = TRUE, area = 1, ci = 0.95, R = 500,
  bySite = FALSE, plot.bs = FALSE, showProgress = TRUE,
  plot = TRUE, criterion = "AICc", ...)
}
\arguments{
\item{formula}{This parameter is passed to \code{dfuncEstim}.
See \code{dfuncEstim} documentation for definition.}

\item{detectionData}{This parameter is passed to \code{dfuncEstim} 
and \code{abundEstim}. See \code{abundEstim} documentation for definition.}

\item{siteData}{This parameter is passed to \code{abundEstim}.
See \code{abundEstim} documentation for definition.}

\item{w.lo}{This parameter is passed to \code{dfuncEstim}.
See \code{dfuncEstim} documentation for definition.}

\item{w.hi}{This parameter is passed to \code{dfuncEstim}.
See \code{dfuncEstim} documentation for definition.}

\item{likelihoods}{Vector of strings specifying the 
likelihoods to consider during model selection. Valid values 
at present are "uniform", "halfnorm", "hazrate", "negexp", 
and "Gamma". See Details for the models this routine considers.}

\item{series}{Vector of series types to consider during model selection. 
Valid values are 'simple', 'hermite', and 'cosine'. See Details for 
the models this routine considers.}

\item{expansions}{Vector of the number of expansion terms to 
consider during model selection. Valid values are 0 through 3. 
See Details for the models this routine considers. Note, expansion terms are not currently
allowed in models with covariates.}

\item{pointSurvey}{This parameter is passed to \code{dfuncEstim}.
See \code{dfuncEstim} documentation for definition.}

\item{warn}{This parameter is passed to \code{dfuncEstim}.
\code{dfuncEstim} documentation for definition.}

\item{area}{This parameter is passed to \code{abundEstim}.
See \code{abundEstim} documentation for definition.}

\item{ci}{This parameter is passed to \code{abundEstim}.
See \code{abundEstim} documentation for definition.}

\item{R}{This parameter is passed to \code{abundEstim}.
See \code{abundEstim} documentation for definition.}

\item{bySite}{This parameter is passed to \code{abundEstim}.
See \code{abundEstim} documentation for definition.}

\item{plot.bs}{Logical for whether to plot bootstrap 
iterations after the top model has been selected and 
during final estimation of confidence intervals.  
This parameter is passed unchanged to \code{abundEstim}.
See \code{abundEstim} help for additional information.}

\item{showProgress}{Logical for whether to 
suppress intermediate output.  If \code{showProgress=TRUE}, 
a table of model fitting results appears in the console as they 
are estimated, and a progress bar shows progress through 
the bootstrap iterations at the end.  If \code{showProgress=FALSE}, 
all intermediate output is suppressed which is handy for programming
and simulations.}

\item{plot}{Logical scalar specifying whether to plot models during model selection. 
If \code{TRUE}, a histogram with fitted distance function is plotted for every fitted model. 
The function pauses between each plot and prompts the user for whether they want to continue or not. 
For completely automated estimation, set \code{plot} = \code{FALSE}.}

\item{criterion}{A string specifying the criterion to use when assessing model fit.
The best fitting model from this routine is the one with lowest value 
of this fit criterion.  This must be one of "AICc" (the default), 
"AIC", or "BIC".  See \code{\link{AIC.dfunc}} for formulas.}

\item{...}{Additional parameters passed to \code{dfuncEstim}, which in turn are passed to \code{F.gx.estim}. 
These include \code{x.scl}, \code{g.x.scl}, and \code{observer} for estimating double observer probabilities.}
}
\value{
If \code{bySite==FALSE}, an 'abundance estimate' object is returned.
See \code{abundEstim} 
and \code{dfuncEstim} for an explanation of components. 
Returned abundance estimates are based 
on the best fitting distance function among those fitted.
A fit table, sorted by the criterion, is returned as component
\code{$fitTable}.  The fit table component contains columns
\code{like} (likelihood), \code{series}, \code{expansions},
\code{converge} (0=converged,1=not), \code{scale} (1=passed scale
check,0=did not pass), and 
\code{aic} (the criterion used). 

If \code{bySite==TRUE}, a data frame containing site-level
abundance based on the best-fitting detection function is returned.
See \code{\link{abundEstim}} for description of columns in 
the data frame.  The best-fitting likelihood form, series, 
and number of expansions are returned as attributes of the 
data frame (e.g., best-fitting likelihood is \code{attr(out,"like.form")}).
}
\description{
Perform automated classical detection function selection and 
estimation of abundance.
}
\details{
During model selection, each series and number of expansions is crossed with 
each of the likelihoods. For example, if \code{likelihoods} has 3 elements, 
\code{series} has 2 elements, and \code{expansions} has 4 elements, 
the total number of models fitted is 3 (likelihoods) * 2 (series) * 4 (expansions) 
= 24 models.  The default specification fits 41 detection functions 
from the "halfnorm", "hazrate", "uniform", "negexp", and "Gamma" likelihoods 
(note that Gamma does not currently implement expansions, see 
\code{\link{Gamma.like}}). Note, expansion terms are not currently
allowed in models with covariates.  The model with lowest AIC is selected 
as 'best', and estimation of abundance proceeds using that model.

Suppress all intermediate output using \code{plot.bs=FALSE}, 
\code{showProgress=FALSE}, and \code{plot=FALSE}.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDetectionData)
data(sparrowSiteData)

# Automate fitting multiple detection functions, and estimate abundance
# (density per ha in this case), given the 'best' detection function
# Note, area=10000 converts to density per ha (for distances measured in m)
# Note, users should do more than R=20 iterations of the bootstrap
autoDistSamp(formula=dist ~ 1,
             detectionData=sparrowDetectionData, siteData=sparrowSiteData,
             likelihood=c("halfnorm", "hazrate"), w.hi=100,
             series=c("cosine", "simple"), expansions=c(0, 1),
             area=10000, R=20, ci=0.95, bySite=FALSE,
             plot.bs=TRUE, plot=FALSE, pointSurvey=FALSE)
}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{abundEstim}}.
}
\author{
Trent McDonald, WEST Inc.,  \email{tmcdonald@west-inc.com}\cr
        Aidan McDonald, WEST Inc.,  \email{aidan@mcdcentral.org}\cr
        Jason Carlisle, University of Wyoming and WEST Inc., \email{jcarlisle@west-inc.com}
}
\keyword{model}
