% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_incisingball.R
\name{est.incisingball}
\alias{est.incisingball}
\title{Intrinsic Dimension Estimation with Incising Ball}
\usage{
est.incisingball(X)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Incising ball methods exploits the exponential relationship of the number of samples
contained in a ball and the radius of the incising ball.
}
\examples{
\donttest{
## create an example data with intrinsic dimension 2
X = cbind(aux.gensamples(dname="swiss"),aux.gensamples(dname="swiss"))

## acquire an estimate for intrinsic dimension
output = est.incisingball(X)
sprintf("* est.incisingball : estimated dimension is \%d.",output$estdim)
}

}
\references{
\insertRef{fan_intrinsic_2009}{Rdimtools}
}
\author{
Kisung You
}
