% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mindkl.R
\name{est.mindkl}
\alias{est.mindkl}
\title{MiNDkl}
\usage{
est.mindkl(X, k = 5)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{k}{the neighborhood size for defining locality.}
}
\value{
a named list containing containing \describe{
\item{estdim}{the global estimated dimension.}
}
}
\description{
It is a minimum neighbor distance estimator of the intrinsic dimension based on Kullback Leibler divergence estimator.
}
\examples{
\donttest{
## create 3 datasets of intrinsic dimension 2.
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="saddle")

## acquire an estimate for intrinsic dimension
out1 = est.mindkl(X1, k=10)
out2 = est.mindkl(X2, k=10)
out3 = est.mindkl(X3, k=10)

## print the results
sprintf("* est.mindkl : estimated dimension for 'swiss'  data is \%.2f.",out1$estdim)
sprintf("* est.mindkl : estimated dimension for 'ribbon' data is \%.2f.",out2$estdim)
sprintf("* est.mindkl : estimated dimension for 'saddle' data is \%.2f.",out3$estdim)
}

}
\references{
\insertRef{lombardi_minimum_2011}{Rdimtools}
}
\seealso{
\code{\link{est.mindml}}
}
\author{
Kisung You
}
