% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_FA.R
\name{do.fa}
\alias{do.fa}
\title{Exploratory Factor Analysis}
\usage{
do.fa(
  X,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  maxiter = 1000,
  tolerance = 1e-06
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued number of loading variables, or target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{maxiter}{maximum number of iterations for updating.}

\item{tolerance}{stopping criterion in a Frobenius norm.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{loadings}{a \eqn{(p\times ndim)} matrix whose rows are extracted loading factors.}
\item{noise}{a length-\eqn{p} vector of estimated noise.}
}
}
\description{
\code{do.fa} is an optimization-based implementation of a popular technique for Exploratory Data Analysis.
It is closely related to principal component analysis.
}
\examples{
\donttest{
## use iris data
data(iris)
X = as.matrix(iris[,1:4])
lab = as.factor(iris[,5])

## 1. use centered data
output1 <- do.fa(X,ndim=2)

## 2. use decorrelated data
output2 <- do.fa(X,ndim=2,preprocess="decorrelate")

## 3. use whitened data
output3 <- do.fa(X,ndim=2,preprocess="whiten")

## Visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(3,1))
plot(output1$Y, col=lab, main="FA::centered")
plot(output2$Y, col=lab, main="FA::decorrelated")
plot(output3$Y, col=lab, main="FA::whitened")
par(opar)
}

}
\references{
\insertRef{spearman_general_1904}{Rdimtools}
}
\author{
Kisung You
}
