% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_NPCA.R
\name{do.npca}
\alias{do.npca}
\title{Nonnegative Principal Component Analysis}
\usage{
do.npca(
  X,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  maxiter = 1000,
  reltol = 1e-05
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{maxiter}{number of maximum iteraions allowed.}

\item{reltol}{stopping criterion for incremental relative error.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Nonnegative Principal Component Analysis (NPCA) is a variant of PCA where
projection vectors - or, basis for learned subspace - contain no negative values.
}
\examples{
\dontrun{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])+50
label = as.integer(iris$Species)

## use different preprocessing
out1 = do.npca(X, preprocess="center")
out2 = do.npca(X, preprocess="cscale")
out3 = do.npca(X, preprocess="whiten")

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="NPCA:: center")
plot(out2$Y, col=label, main="NPCA:: cscale")
plot(out3$Y, col=label, main="NPCA:: whiten")
par(opar)
}

}
\references{
\insertRef{zafeiriou_nonnegative_2010}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
