% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LSCORE.R
\name{do.lscore}
\alias{do.lscore}
\title{Laplacian Score}
\usage{
do.lscore(X, ndim = 2, type = c("proportion", 0.1), preprocess = c("null",
  "center", "scale", "cscale", "whiten", "decorrelate"), t = 10)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{t}{bandwidth parameter for heat kernel in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Laplacian Score (LSCORE) is an unsupervised linear feature extraction method. For each
feature/variable, it computes Laplacian score based on an observation that data from the
same class are often close to each other. Its power of locality preserving property is used, and
the algorithm selects variables with largest scores.
}
\examples{
\dontrun{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## try different kernel bandwidth
out1 = do.lscore(X, t=0.1)
out2 = do.lscore(X, t=1)
out3 = do.lscore(X, t=10)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="bandwidth=0.1")
plot(out2$Y[,1], out2$Y[,2], main="bandwidth=1")
plot(out3$Y[,1], out3$Y[,2], main="bandwidth=10")
}

}
\references{
\insertRef{he_laplacian_2005}{Rdimtools}
}
\author{
Kisung You
}
