% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LPMIP.R
\name{do.lpmip}
\alias{do.lpmip}
\title{Locality-Preserved Maximum Information Projection}
\usage{
do.lpmip(X, ndim = 2, type = c("proportion", 0.1), preprocess = c("null",
  "center", "scale", "cscale", "whiten", "decorrelate"), sigma = 10,
  alpha = 0.5)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{sigma}{bandwidth parameter for heat kernel in \eqn{(0,\infty)}.}

\item{alpha}{balancing parameter between two locality information in \eqn{[0,1]}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Locality-Preserved Maximum Information Projection (LPMIP) is an unsupervised linear dimension reduction method
to identify the underlying manifold structure by learning both the within- and between-locality information. The
parameter \code{alpha} is balancing the tradeoff between two and the flexibility of this model enables an interpretation
of it as a generalized extension of LPP.
}
\examples{
## generate default dataset
X <- aux.gensamples(n=123)

## try different neighborhood size
out1 <- do.lpmip(X, ndim=2, type=c("proportion",0.01))
out2 <- do.lpmip(X, ndim=2, type=c("proportion",0.1))
out3 <- do.lpmip(X, ndim=2, type=c("proportion",0.25))

## Visualize
par(mfrow=c(1,3))
plot(out1$Y[,1],out1$Y[,2],main="1\% connected")
plot(out2$Y[,1],out2$Y[,2],main="10\% connected")
plot(out3$Y[,1],out3$Y[,2],main="25\% connected")

}
\references{
\insertRef{haixian_wang_locality-preserved_2008}{Rdimtools}
}
\author{
Kisung You
}
