% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LDP.R
\name{do.ldp}
\alias{do.ldp}
\title{Locally Discriminating Projection}
\usage{
do.ldp(X, label, ndim = 2, type = c("proportion", 0.1),
  preprocess = c("center", "whiten", "decorrelate"), beta = 10)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{beta}{bandwidth parameter for heat kernel in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Locally Discriminating Projection (LDP) is a supervised linear dimension reduction method.
It utilizes both label/class information and local neighborhood information to discover
the intrinsic structure of the data. It can be considered as an extension
of LPP in a supervised manner.
}
\examples{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## try different neighborhood sizes
out1 = do.ldp(X, label, type=c("proportion",0.01))
out2 = do.ldp(X, label, type=c("proportion",0.05))
out3 = do.ldp(X, label, type=c("proportion",0.10))

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="1\% connectivity")
plot(out2$Y[,1], out2$Y[,2], main="5\% connectivity")
plot(out3$Y[,1], out3$Y[,2], main="10\% connectivity")

}
\references{
\insertRef{zhao_local_2006}{Rdimtools}
}
\author{
Kisung You
}
