% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KLDE.R
\name{do.klde}
\alias{do.klde}
\title{Kernel Local Discriminant Embedding}
\usage{
do.klde(X, label, ndim = 2, t = 1, numk = max(ceiling(nrow(X)/10), 2),
  preprocess = c("center", "decorrelate", "whiten"), ktype = c("gaussian",
  1), kcentering = FALSE)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{t}{kernel bandwidth in \eqn{(0,\infty)}.}

\item{numk}{the number of neighboring points for k-nn graph construction.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{ktype}{a vector containing name of a kernel and corresponding parameters. See also \code{\link{aux.kernelcov}} for complete description of Kernel Trick.}

\item{kcentering}{a logical; \code{TRUE} to use centered Kernel matrix, \code{FALSE} otherwise.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Kernel Local Discriminant Embedding (KLDE) is a variant of Local Discriminant Embedding in that
it aims to preserve inter- and intra-class neighborhood information in a nonlinear manner using
kernel trick. \emph{Note} that the combination of kernel matrix and its eigendecomposition
often suffers from lacking numerical rank. For such case, our algorithm returns a warning message and
algorithm stops working any further due to its innate limitations of constructing weight matrix.
}
\examples{
\dontrun{
## generate data of 2 types with clear difference
diff = 5
dt1  = aux.gensamples(n=123)-diff;
dt2  = aux.gensamples(n=123)+diff;

## merge the data and create a label correspondingly
Y      = rbind(dt1,dt2)
label  = c(rep(1,123), rep(2,123))

## try different neighborhood size
out1 <- do.klde(Y, label, kcentering=TRUE, numk=5)
out2 <- do.klde(Y, label, numk=10)
out3 <- do.klde(Y, label, numk=25)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="k=5")
plot(out2$Y[,1], out2$Y[,2], main="k=10")
plot(out3$Y[,1], out3$Y[,2], main="k=25")
}

}
\references{
\insertRef{hwann-tzong_chen_local_2005}{Rdimtools}
}
\author{
Kisung You
}
