% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_DNE.R
\name{do.dne}
\alias{do.dne}
\title{Discriminant Neighborhood Embedding}
\usage{
do.dne(X, label, ndim = 2, numk = max(ceiling(nrow(X)/10), 2),
  preprocess = c("center", "decorrelate", "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{numk}{the number of neighboring points for k-nn graph construction.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Discriminant Neighborhood Embedding (DNE) is a supervised subspace learning method.
DNE tries to move multi-class data points in high-dimensional space in accordance with
local intra-class attraction and inter-class repulsion.
}
\examples{
#' @examples
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
Y      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## try different numbers for neighborhood size
out1 = do.dne(Y, label, numk=5)
out2 = do.dne(Y, label, numk=10)
out3 = do.dne(Y, label, numk=25)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="nbd size=5")
plot(out2$Y[,1], out2$Y[,2], main="nbd size=10")
plot(out3$Y[,1], out3$Y[,2], main="nbd size=25")

}
\references{
\insertRef{zhang_discriminant_2006}{Rdimtools}
}
\author{
Kisung You
}
