% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{roxygen_and_build}
\alias{roxygen_and_build}
\alias{rab}
\title{Roxygenize a package, clean up and build/check the package}
\usage{
roxygen_and_build(pkg, build = TRUE, build.opts = "--no-manual",
  install = FALSE, install.opts = if (build) "" else
  "--with-keep.source", check = FALSE,
  check.opts = "--as-cran --no-manual", remove.check = TRUE,
  reformat = TRUE, before = NULL, ...)

rab(pkg, build = TRUE, build.opts = "--no-manual", install = FALSE,
  install.opts = if (build) "" else "--with-keep.source",
  check = FALSE, check.opts = "--as-cran --no-manual",
  remove.check = TRUE, reformat = TRUE, before = NULL, ...)
}
\arguments{
\item{pkg}{the root directory of the source package}

\item{build}{whether to build the package}

\item{build.opts}{options to be passed to \command{R CMD build}}

\item{install}{whether to install the package}

\item{install.opts}{options to be passed to \command{R CMD INSTALL}}

\item{check}{whether to check the package}

\item{check.opts}{options to check the package (e.g. \code{"--no-examples"})}

\item{remove.check}{whether to remove the directory generated by \command{R
CMD check}}

\item{reformat}{whether to reformat the example code; see
\code{\link{reformat_code}}}

\item{before}{an R expression to be evaluated under the package root
directory before the package is roxygenized and built}

\item{...}{other arguments passed to \code{\link[roxygen2]{roxygenize}}}
}
\value{
\code{NULL}
}
\description{
After the source package is roxygenized, this function will build the
package. Optionally it also installs or checks the package, reformats the
code in the example sections. Note \code{\link{rab}} is an alias of
\code{\link{roxygen_and_build}}.
}
\examples{
\dontrun{
roxygen_and_build("Rd2roxygen", install = TRUE)
## or simply
rab("Rd2roxygen", install = TRUE)
}
}
\author{
Yihui Xie <\url{http://yihui.name}>
}
