% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompadreMat.R, R/ClassUnionMethods.R
\docType{class}
\name{CompadreMatrixMethods}
\alias{CompadreMatrixMethods}
\alias{matA}
\alias{matA,CompadreMat-method}
\alias{matA,CompadreDB-method}
\alias{matA,list-method}
\alias{matU}
\alias{matU,CompadreMat-method}
\alias{matU,CompadreDB-method}
\alias{matU,list-method}
\alias{matF}
\alias{matF,CompadreMat-method}
\alias{matF,CompadreDB-method}
\alias{matF,list-method}
\alias{matC}
\alias{matC,CompadreMat-method}
\alias{matC,CompadreDB-method}
\alias{matC,list-method}
\alias{matrixClass}
\alias{matrixClass,CompadreMat-method}
\alias{matrixClass,CompadreDB-method}
\alias{matrixClass,list-method}
\alias{MatrixClassAuthor}
\alias{MatrixClassAuthor,CompadreMat-method}
\alias{MatrixClassAuthor,CompadreDB-method}
\alias{MatrixClassAuthor,list-method}
\alias{MatrixClassOrganized}
\alias{MatrixClassOrganized,CompadreMat-method}
\alias{MatrixClassOrganized,CompadreDB-method}
\alias{MatrixClassOrganized,list-method}
\alias{MatrixClassNumber}
\alias{MatrixClassNumber,CompadreMat-method}
\alias{MatrixClassNumber,CompadreDB-method}
\alias{MatrixClassNumber,list-method}
\title{Methods for working with matrices in com(p)adre}
\usage{
matA(object)

\S4method{matA}{CompadreMat}(object)

\S4method{matA}{CompadreDB}(object)

\S4method{matA}{list}(object)

matU(object)

\S4method{matU}{CompadreMat}(object)

\S4method{matU}{CompadreDB}(object)

\S4method{matU}{list}(object)

matF(object)

\S4method{matF}{CompadreMat}(object)

\S4method{matF}{CompadreDB}(object)

\S4method{matF}{list}(object)

matC(object)

\S4method{matC}{CompadreMat}(object)

\S4method{matC}{CompadreDB}(object)

\S4method{matC}{list}(object)

matrixClass(object)

\S4method{matrixClass}{CompadreMat}(object)

\S4method{matrixClass}{CompadreDB}(object)

\S4method{matrixClass}{list}(object)

MatrixClassAuthor(object)

\S4method{MatrixClassAuthor}{CompadreMat}(object)

\S4method{MatrixClassAuthor}{CompadreDB}(object)

\S4method{MatrixClassAuthor}{list}(object)

MatrixClassOrganized(object)

\S4method{MatrixClassOrganized}{CompadreMat}(object)

\S4method{MatrixClassOrganized}{CompadreDB}(object)

\S4method{MatrixClassOrganized}{list}(object)

MatrixClassNumber(object)

\S4method{MatrixClassNumber}{CompadreMat}(object)

\S4method{MatrixClassNumber}{CompadreDB}(object)

\S4method{MatrixClassNumber}{list}(object)
}
\arguments{
\item{object}{A CompadreDB object}
}
\description{
This page describes methods for accessing any matrix information from 
CompadreMat and CompadreDB objects.

Most methods for working with matrices are applicable to both CompadreMat and 
CompadreDB objects. These are described on this page (along with a couple) 
of methods applicable to only CompadreMat or CompadreDB objects).
}
\section{Slots}{

\describe{
\item{\code{matA}}{A matrix population model (i.e. a square projection matrix)}

\item{\code{matU}}{The survival component of a matrix population model (i.e. a square
projection matrix reflecting survival-related transitions; e.g.
progression, stasis, and retrogression)}

\item{\code{matF}}{The sexual component of a matrix population model (i.e. a square
projection matrix reflecting transitions due to sexual reproduction)}

\item{\code{matC}}{The clonal component of a matrix population model (i.e. a square
projection matrix reflecting transitions due to clonal reproduction)}

\item{\code{matrixClass}}{A data frame with columns \code{MatrixClassOrganized}
(elements are "active", "prop", or "dorm") \code{MatrixClassAuthor} (the
matrix author's stage description), and \code{MatrixClassNumber} (integer
stage number)}
}}

