\name{Commander}
\alias{Commander}

\title{R Commander}
\description{
  Start the R Commander GUI (graphical user interface)
}
\usage{
Commander()
}

\details{

\bold{Getting Started}

Commands to read, write, transform, and analyze data are entered using the menus in the
menu bar at the top of the \emph{Commander} window. Most menu items lead to dialog boxes
requesting further specification. I suggest that you explore the menus to see
what is available.

Below the menu bar is an information field
displaying the name of the active data set; buttons for editing and displaying the active
data set in the R data editor; and check boxes for logging commands and attaching the active
data set to the R search path. The information field for the active data set is actually a
button that can be used to select the active data set from data frames in memory.

By default, commands are logged to the log/script window (the
large, initially empty window immediately below), and the active data set is attached to the
search path. Below the log window is an information field showing the active statistical model,
and a \emph{Submit} button for re-executing commands in the log window. The information field
for the active model is a button that can be used to select the active model from among linear
and generalized linear model objects in memory.

Almost all commands require an active data set. When the Commander starts, there is no active
data set, as indicated in the data set information field. A data set becomes the active data set
when it is read into memory from an R package or imported from a text file, SPSS data set, or
Minitab data set. In addition, the active data set may be selected from among R data frames
resident in memory. You may therefore switch among data sets during a session.

Some \code{Rcmdr} dialogs (those in the \emph{Statistics -> Fit models} menu) 
produce linear or generalized 
linear models. When a model is fit, it becomes the active model, as indicated in the information
field at the lower-left of the \emph{Commander} window.
Items in the \emph{Models} menu apply to the active model. Initially, there is no active model. 
If there are several models in memory, you may select the active model from among them.

If command logging in turned on, R commands that are generated from the menus and dialog boxes are
entered into the log/script window in the Commander. You can edit these commands in the normal
manner and can also type new commands into the log/script window. The contents of the log
window can be saved during or at the end of the session, and a saved log can be loaded into the
log window. 

To re-execute a command or set of commands, select the lines to be executed using
the mouse and press the \emph{Submit} button at the lower-right of the \emph{Commander} window
(or \emph{Control-R}, for "run"). If no text is selected, the \emph{Submit} button (or \emph{Control-R}) 
submits the line containing the text-insertion cursor. 

When you
execute commands from the \emph{Commander} window, you must ensure that the sequence of commands
is logical. For example, it makes no sense to fit a statistical model to a data set that has
not been read into memory. Commands generated by the Commander or executed from the log window
appear in the R session window with an "\code{R-cmdr>}" prefix. 

Exit from the Commander via the \emph{File -> Exit} menu or by closing the \emph{Commander} window.

\bold{Customization and Configuration}

Configuration files reside in the \code{etc} subdirectory of the package.

The \code{Rcmdr} menus may be customized by editing the file \code{Rcmdr-menus.txt}.

Some functions (e.g., \code{hist}) that do not normally create visible printed output when executed
from the command prompt will do so --- unless prevented --- when executed from the 
\emph{Commander} log window. Such output
can be suppressed by listing the names of these functions in the \code{log-exceptions.txt} file.

You can add R code to the package, e.g., for creating additional dialogs, by placing files with
file type \code{.R} in the \code{etc} directory, also editing \code{Rcmdr-menus.txt} to provide
additional menus, sub-menus, or menu-items. A demo addition is provided in the file 
\code{compareModels.demo}. To activate the demo, rename this file to \code{compareModels.R},
and uncomment the corresponding menu line in \code{Rcmdr-menus.txt}. Alternatively, you can edit 
the source package and recompile it.

The following functions are provided to assist in writing dialogs: \code{activeDataSet}, 
\code{activeModel}, \code{doItAndPrint}, \code{justDoIt}, \code{listDataSets}, 
\code{listGeneralizedLinearModels}, \code{listLinearModels}, \code{logger}. The following global
variables contain information about variables in the active data set: \code{.factors},
\code{.numeric}, \code{.twoLevelFactors}, \code{.variables}. See \code{help(Rcmdr.Utilities)}
for more information.

In addition, several features are controlled by run-time options, set via the \code{options("Rcmdr")}
command. These options should be set before the package is loaded. If the options are unset, which is
the usual situation, defaults are used. Specify options as a list of \emph{name=value} pairs. You can
set none, one, several, or all options. The available options are as follows:

\describe{
    \item{\code{log.font.size}}{The font size, in points, to be used in the log/script window,
    in recode dialogs, and in compute expressions --- that is, where a monospaced font is used. 
    The default is 10.}
    
    \item{\code{log.width}}{The width of the log window, in characters. The default is 70.}
    
    \item{\code{log.height}}{The height of the log window, in lines. The default is 15.}
    
    \item{\code{contrasts}}{Serves the same function as the general \code{contrasts} option; the default is 
    \code{c("contr.Treatment", "contr.poly")}. When the Commander exits, the \code{contrasts}
    option is returned to its pre-existing value. Note that \code{contr.Treatment} is from the \code{car} package.}
    
    \item{\code{grab.focus}}{Set to \code{TRUE} (the default) for the current Tk window to 
    "grab" the focus --- that is, to prevent the focus from being changed to another Tk window.
    On some systems, grabbing the focus in this manner apparently causes the OK, Cancel, and
    Help buttons to be disabled after the user types in a text field. If you experience this
    problem, set the \code{grab.focus} option to \code{FALSE}.}
    
    \item{\code{double.click}}{Set to \code{TRUE} if you want a double-click of the left mouse
    button to press the default button in all dialogs. The default is \code{FALSE}.}
    
    \item{\code{scale.factor}}{A scaling factor to be applied to all Tk elements, such as fonts. This works well
    only in Windows. The default is \code{NULL}.}
    
    \item{\code{default.font.size}}{The size, in points, of the default font. The default is 10. Unless otherwise 
    specified (see the next item), the default font is \code{"*helvetica-medium-r-normal-*-xx*"}, where \code{xx}
    is the default font size. This option is only for non-Windows systems.}
    
    \item{\code{default.font}}{The default font, as an X11 font specification, given in a character string. 
    If specified, this value takes precedence
    over the default font size (above). This option is only for non-Windows systems.}
    
    \item{\code{tkwait}}{This option addresses a problem that, to my knowledge, is rare, 
    and may occur on some non-Windows systems. If the Commander causes R to hang, 
    then set the \code{tkwait} option to
    \code{TRUE}; otherwise set the option to \code{FALSE} or ignore it. 
    An undesirable side effect of setting
    the \code{tkwait} option to \code{TRUE} is that the R session command prompt is suppressed until the Commander exits.
    One can still enter commands via the log/script window, however. In particular, there is no reason to use this option
    under Windows, and it should not be used with the Windows R GUI with buffered output.}
    }
    
Most options may also be set via the File -> Options menu, which will restart the Commander after options are set.
}

\author{John Fox \email{jfox@mcmaster.ca}}

\examples{
    options(Rcmdr=list(log.font.size=12, contrasts=c("contr.Sum", "contr.poly")))
    }
}

\keyword{misc}
