% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rchoice.methods.R
\name{plot.Rchoice}
\alias{plot.Rchoice}
\title{Plot the distribution of conditional expectation for random parameters.}
\usage{
\method{plot}{Rchoice}(
  x,
  par = NULL,
  effect = c("ce", "cv"),
  wrt = NULL,
  type = c("density", "histogram"),
  adjust = 1,
  main = NULL,
  col = "indianred1",
  breaks = 10,
  ylab = NULL,
  xlab = NULL,
  ind = FALSE,
  id = NULL,
  ...
)
}
\arguments{
\item{x}{a object of class \code{Rchoice},}

\item{par}{a string giving the name of the variable with random parameter,}

\item{effect}{a string indicating what should be plotted: the conditional expectation of the individual coefficients "\code{ce}", or the conditional expectation of the individual compensating variations "\code{cv}",}

\item{wrt}{a string indicating repect to which variable should be computed the compensating variation,}

\item{type}{a string indicating the type of distribution: it can be a \code{histogram} or a \code{density} of
the conditional expectation,}

\item{adjust}{bandwidth for the kernel density,}

\item{main}{an overall title for the plot,}

\item{col}{color for the graph,}

\item{breaks}{number of breaks for the histrogram if \code{type = "histogram"},}

\item{ylab}{a title for the y axis,}

\item{xlab}{a title for the x axis,}

\item{ind}{a boolean. If \code{TRUE}, a 95% interval of conditional distribution for each individual is plotted. 
As default, the conditional expectation of \code{par} for the first 10 individual is plotted,}

\item{id}{only relevant if \code{ind} is not \code{NULL}. This is a vector indicating the individuals for which the confidence intervals are plotted,}

\item{...}{further arguments. Ignored.}
}
\description{
Plot the distribution of the conditional expectation of the random parameters or compensating variations for objects of class \code{Rchoice}.
}
\examples{
\donttest{
# Poisson with random parameters
data("Articles")
poisson.ran <- Rchoice(art ~ fem + mar + kid5 + phd + ment, 
                       data = Articles,  family = poisson,
                       ranp = c(kid5 = "n", phd = "n", ment = "n"), 
                       R = 10)

## Plot the distribution of the conditional mean for ment
plot(poisson.ran, par = "ment", type = "density")

## Plot the conditional mean for the first 20 individuals
plot(poisson.ran, par = "ment", ind =  TRUE, id = 1:20, col = "blue")

## Plot the compensating variation with respect to fem
plot(poisson.ran, par = "ment", effect = "cv", wrt = "fem", type = "histogram")
}
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete choice methods with simulation. Cambridge university press.
}
}
\seealso{
\code{\link[Rchoice]{Rchoice}} for the estimation of different discrete choice models with individual parameters.
}
\author{
Mauricio Sarrias
}
