% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvi_getparams.R
\name{rvn_rvi_getparams}
\alias{rvn_rvi_getparams}
\title{Retrieve Parameter Information from RVI file Algorithms}
\usage{
rvn_rvi_getparams(
  rvi,
  RavenAlgParamsFile = system.file("extdata", "RavenAlgParams.dat", package = "RavenR"),
  RavenParamsFile = system.file("extdata", "RavenParameters.dat", package = "RavenR")
)
}
\arguments{
\item{rvi}{data object generated from the \code{\link{rvn_rvi_read}} routine}

\item{RavenAlgParamsFile}{(optional) path to RavenAlgParams.dat file}

\item{RavenParamsFile}{(optional) path to RavenParameters.dat file}
}
\value{
Returns a data frame with parameter information containing the parameter name, parameter class, units, auto (whether
the parameter may be autogenerated within Raven), default, min, and max values. Note that the flags 'xxx',
-9999, and 9999 are used as missing values within the parameter data frame.
}
\description{
Reads the processed rvi object and returns a data frame of parameter information for parameters
associated with processes in the rvi object.
}
\details{
Uses the Raven master information in the /extdata folder to (1) associate parameters with particular algorithms,
and (2) subset the master parameter list based on the information in the rvi file.

These files are stored with the RavenR package and retrived with this function by default,
but a separate link may be provided to a modified file if desired.
}
\examples{
# sample workflow of rvn_rvi_read
rvi <- system.file("extdata","Nith.rvi", package="RavenR") \%>\%
rvn_rvi_read(.)

# get data frame of parameters related to processes in rvi file
rvn_rvi_getparams(rvi)

}
