% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customize_table.R
\name{customize_table}
\alias{customize_table}
\title{Customize a Summary Table with Grouping, Missing Data, and Custom Titles}
\usage{
customize_table(
  base_table,
  by_group = FALSE,
  var_group,
  add_total,
  show_missing_data,
  show_n_per_group,
  group_title,
  table_title,
  var_title,
  var_tot = NULL,
  var_characteristic = NULL
)
}
\arguments{
\item{base_table}{A \code{gtsummary} table object, typically generated using functions
like \code{gtsummary::tbl_summary}.}

\item{by_group}{A boolean (default is FALSE) to analyse by group.}

\item{var_group}{A string or NULL, specifying the variable used for grouping in the
table. If \code{NULL}, no group-specific modifications are applied.}

\item{add_total}{A boolean to add total column or not when var_group is specified.}

\item{show_missing_data}{A boolean indicating whether to display missing data counts
and percentages in the table. If \code{TRUE}, columns for missing data will be added.}

\item{show_n_per_group}{A boolean indicating whether to display group sizes (n) for
each level of the grouping variable.}

\item{group_title}{A string specifying the title for the group column in the table.}

\item{table_title}{A string specifying the title of the entire table.}

\item{var_title}{A string specifying the title for the variable column in the table.}

\item{var_tot}{A string specifying the name of total column. Default is \code{NULL} and will guess from \code{theme_gtsummary_language()}.}

\item{var_characteristic}{A string specifying the name of characteristic column. Default is \code{NULL} and will guess from \code{theme_gtsummary_language()}.}
}
\value{
A customized \code{gtsummary} table object with added columns, headers, captions,
and modifications based on the provided arguments.
}
\description{
This function customizes a \code{gtsummary} summary table by adding an overall column,
handling missing data, applying group-specific statistics, and updating headers
and captions. It provides flexible options for grouping, displaying missing data,
and customizing table titles.
}
\details{
\itemize{
\item The \code{show_missing_data} parameter determines whether missing data counts and
percentages are displayed:
\itemize{
\item If \code{TRUE}, missing data columns are added.
\item If \code{FALSE}, only non-missing data counts are displayed.
}
\item Headers for columns and spanning headers are customized using the \code{group_title},
\code{table_title}, and \code{var_title} arguments.
\item An external function \code{modify_table_body_func} is called to further modify
the table body.
}
}
\examples{
# Example usage with a sample gtsummary table
library(gtsummary)
base_table <- trial \%>\%
  tbl_summary(by = "trt", missing = "no")

customize_table(
  base_table,
  var_group = "trt",
  add_total = TRUE,
  show_missing_data = TRUE,
  show_n_per_group = FALSE,
  group_title = "Treatment Group",
  table_title = "Summary Statistics",
  var_title = "Variables",
  var_tot = "Total"
)

}
