% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MU.R
\name{MU}
\alias{MU}
\title{Auxiliary function that computes the singular values of the SVD of the operator F_c in Gaillac and Gautier 2018.}
\usage{
MU(N, c, K, L1)
}
\arguments{
\item{N}{number of singular values to compute}

\item{c}{parameter indexing the singular values}

\item{K}{ordre of the Legendre quadrature}

\item{L1}{number of Legendre polynomials used in the computation of the coefficients of the singular functions;}
}
\value{
a list containing, in order:

- mu_even

- mu_odd
}
\description{
Auxiliary function that computes the singular values of the SVD of the operator F_c in Gaillac and Gautier 2018.
}
\examples{
library(orthopolynom)
library(polynom)
library(tmvtnorm)
library(ks)
library(sfsmisc)
library(snowfall)
library(fourierin)
library(rdetools)
library(statmod)
library(RCEIM)
library(robustbase)
library(VGAM)
library(RandomCoefficients)
#### Bandwidth 1
L =15
L1 = L+1
N2 = max(L,3)
twoN = 2*N2
#### Bandwidth 1
c1 = 1
K1 = max(twoN+2,30)
K = K1
mu1<- MU(N2,c1,K1, L1)
}
