% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{quantKnn}
\alias{quantKnn}
\title{Noise-related quantaties of local pruned k-nearest neighbourhoods}
\usage{
quantKnn(res, noise, object, pvalue = 0.01, minN = 5, no_cores = NULL)
}
\arguments{
\item{res}{List object with k nearest neighbour information returned by \code{pruneKnn} function.}

\item{noise}{List of noise parameters returned by \code{compTBNoise}.}

\item{object}{\code{SCseq} class object.}

\item{pvalue}{Positive real number between 0 and 1. All nearest neighbours with link probability \code{< pvalue} are discarded. Default is 0.01.}

\item{minN}{Positive integer number. Noise inference is only done for k-nearest neighbourhoods with at least \code{minN} neighbours remaining after pruning.}

\item{no_cores}{Positive integer number. Number of cores for multithreading. If set to \code{NULL} then the number of available cores minus two is used. Default is \code{NULL}.}
}
\value{
List object with eight components:
\item{noise.av}{Vector of biological noise average across all genes for each k-nearest neighbourhood.}
\item{noise.ratio}{Vector of ratio between total noise and technical noise averaged across all genes for each k-nearest neighbourhood.}
\item{local.corr}{Vector of average Spearman's correlation coefficient between all cell in a pruned k-nearest neighourhood. }
\item{umi}{Vector of total UMI counts for all cells.}
}
\description{
This function computes a number of noise-related quantities for all pruned k-nearest neighbourhoods.
}
