# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' ZigZagLogistic
#' 
#' Applies the Zig-Zag Sampler to logistic regression, as detailed in Bierkens, Fearnhead, Roberts, The Zig-Zag Process and Super-Efficient Sampling for Bayesian Analysis of Big Data, 2016.
#'
#'
#' @param dataX Matrix containing the independent variables x. The i-th column represents the i-th observation with components x_{1,i}, ..., x_{d-1,i}.
#' @param dataY Vector of length n containing {0, 1}-valued observations of the dependent variable y.
#' @param n_iter Integer indicating the number of iterations, i.e. the number of proposed switches.
#' @param subsampling Boolean. Use Zig-Zag with subsampling if TRUE. 
#' @param controlvariates Boolean. Use Zig-Zag with control variates if TRUE (overriding any value of \code{subsampling}).
#' @param beta0 Optional argument indicating the starting point for the Zig-Zag sampler
#' @param n_samples Number of discrete time samples to extract from the Zig-Zag skeleton.
#' @param n_batches If non-zero, estimate effective sample size through the batch means method, with n_batches number of batches.
#' @param computeCovariance Boolean indicating whether to estimate the covariance matrix.
#' @param upperbound Boolean. If TRUE, sample without subsampling and using a constant upper bound instead of a linear Hessian dependent upper bound
#' @return Returns a list with the following objects:
#' @return \code{skeletonTimes} Vector of switching times
#' @return \code{skeletonPoints} Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{samples} If \code{n_samples > 0}, this is a matrix whose \code{n_samples} columns are samples at fixed intervals along the Zig-Zag trajectory. 
#' @return \code{mode} If \code{controlvariates = TRUE}, this is a vector containing the posterior mode obtained using Newton's method. 
#' @return \code{batchMeans} If \code{n_batches > 0}, this is a matrix whose \code{n_batches} columns are the batch means
#' @return \code{means} If \code{n_batches > 0}, this is a vector containing the means of each coordinate along the Zig-Zag trajectory 
#' @return \code{covariance} If \code{n_batches > 0} or \code{computeCovariance = TRUE}, this is a matrix containing the sample covariance matrix along the trajectory
#' @return \code{asVarEst} If \code{n_batches > 0} this is an estimate of the asymptotic variance along each component
#' @return \code{ESS} If \code{n_batches > 0} this is an estimate of the effective sample size along each component
#' @examples
#' require("RZigZag")
#' generate.logistic.data <- function(beta, nobs) {
#'   ncomp <- length(beta)
#'   dataX <- matrix(rnorm((ncomp -1) * nobs), nrow = ncomp -1);
#'   vals <- beta[1] + colSums(dataX * as.vector(beta[2:ncomp]))
#'   generateY <- function(p) { rbinom(1, 1, p)}
#'   dataY <- sapply(1/(1 + exp(-vals)), generateY)
#'   return(list(dataX, dataY))
#' }
#'
#' beta <- c(1,2)
#' data <- generate.logistic.data(beta, 1000)
#' result <- ZigZagLogistic(data[[1]], data[[2]], 1000, n_samples = 100)
#' plot(result$skeletonPoints[1,], result$skeletonPoints[2,],type='l',asp=1)
#' points(result$samples[1,], result$samples[2,], col='magenta')
#' @export
ZigZagLogistic <- function(dataX, dataY, n_iter, subsampling = TRUE, controlvariates = TRUE, beta0 = numeric(0), n_samples = 0L, n_batches = 0L, computeCovariance = FALSE, upperbound = FALSE) {
    .Call('_RZigZag_ZigZagLogistic', PACKAGE = 'RZigZag', dataX, dataY, n_iter, subsampling, controlvariates, beta0, n_samples, n_batches, computeCovariance, upperbound)
}

#' ZigZagGaussian
#' 
#' Applies the Zig-Zag Sampler to a Gaussian target distribution, as detailed in Bierkens, Fearnhead, Roberts, The Zig-Zag Process and Super-Efficient Sampling for Bayesian Analysis of Big Data, 2016.
#' Assume potential of the form \code{Psi(x) = (x - mu)^T V (x - mu)/2}, i.e. a Gaussian with mean vector \code{mu} and covariance matrix \code{inv(V)}
#'
#' @param V the inverse covariance matrix of the Gaussian target distribution
#' @param mu mean of the Gaussian target distribution
#' @param n_epochs Integer indicating how many times the algorithm processes an equivalent of the full dataset. For basic zig-zag this is identical to the number of iterations of the algorithm. For subsampling and control variates zig-zag this is n times the number of iterations, since every iteration has cost 1/n of an epoch. Here n is the number of observations.
#' @param x0 optional vector argument specifying the starting point for the Zig-Zag sampler
#' @param n_samples Number of discrete time samples to extract from the Zig-Zag skeleton.
#' @param n_batches If non-zero, estimate effective sample size through the batch means method, with n_batches number of batches.
#' @param computeCovariance Boolean indicating whether to estimate the covariance matrix.
#' @param c optional argument, specifies which fraction of the data is used to determine a reference point for ZZ-CV. Values for c < 1 give a suboptimal reference point.
#' @return Returns a list with the following objects:
#' @return \code{skeletonTimes}: Vector of switching times
#' @return \code{skeletonPoints}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}
#' @return \code{samples}: If \code{n_samples > 0}, this is a matrix whose \code{n_samples} columns are samples along the Zig-Zag trajectory.
#' @return \code{mode}: If \code{controlvariates = TRUE}, this is a vector containing the posterior mode obtained using Newton's method. 
#' @return \code{batchMeans}: If \code{n_batches > 0}, this is a matrix whose \code{n_batches} columns are the batch means
#' @return \code{means}: If \code{n_batches > 0}, this is a vector containing the means of each coordinate along the Zig-Zag trajectory 
#' @return \code{covariance} :If \code{n_batches > 0} or \code{computeCovariance = TRUE}, this is a matrix containing the sample covariance matrix along the trajectory
#' @return \code{asVarEst}: If \code{n_batches > 0} this is an estimate of the asymptotic variance along each component
#' @return \code{ESS}: If \code{n_batches > 0} this is an estimate of the effective sample size along each component
#' @examples
#' V <- matrix(c(3,1,1,3),nrow=2,ncol=2)
#' mu <- c(2,2)
#' result <- ZigZagGaussian(V, mu, 100, n_samples = 10)
#' plot(result$skeletonPoints[1,], result$skeletonPoints[2,],type='l',asp=1)
#' points(result$samples[1,], result$samples[2,], col='magenta')
#' @export
ZigZagGaussian <- function(V, mu, n_epochs, x0 = numeric(0), n_samples = 0L, n_batches = 0L, computeCovariance = FALSE, c = 1) {
    .Call('_RZigZag_ZigZagGaussian', PACKAGE = 'RZigZag', V, mu, n_epochs, x0, n_samples, n_batches, computeCovariance, c)
}

