/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Settings;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.CSVLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;
import weka.core.converters.SerializedInstancesLoader;
import weka.core.converters.URLSourcedLoader;
import weka.datagenerators.DataGenerator;
import weka.experiment.InstanceQuery;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.AbstractPerspective;
import weka.gui.AttributeSelectionPanel;
import weka.gui.AttributeSummaryPanel;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.ConverterFileChooser;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.Perspective;
import weka.gui.PerspectiveInfo;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.ViewerDialog;
import weka.gui.WorkbenchApp;
import weka.gui.beans.AttributeSummarizer;
import weka.gui.explorer.DataGeneratorPanel;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.sql.SqlViewerDialog;

@PerspectiveInfo(ID="weka.gui.explorer.preprocesspanel", title="Preprocess", toolTipText="Preprocess data", iconPath="weka/gui/weka_icon_new_small.png")
public class PreprocessPanel
extends AbstractPerspective
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    private static final long serialVersionUID = 6764850273874813049L;
    protected InstancesSummaryPanel m_InstSummaryPanel = new InstancesSummaryPanel();
    protected JButton m_OpenFileBut = new JButton("Open file...");
    protected JButton m_OpenURLBut = new JButton("Open URL...");
    protected JButton m_OpenDBBut = new JButton("Open DB...");
    protected JButton m_GenerateBut = new JButton("Generate...");
    protected JButton m_UndoBut = new JButton("Undo");
    protected JButton m_EditBut = new JButton("Edit...");
    protected JMenuItem m_EditM = new JMenuItem("Edit...");
    protected JMenu m_sendToPerspective;
    protected JButton m_SaveBut = new JButton("Save...");
    protected AttributeSelectionPanel m_AttPanel = new AttributeSelectionPanel();
    protected JButton m_RemoveButton = new JButton("Remove");
    protected AttributeSummaryPanel m_AttSummaryPanel = new AttributeSummaryPanel();
    protected GenericObjectEditor m_FilterEditor = new GenericObjectEditor();
    protected PropertyPanel m_FilterPanel = new PropertyPanel(this.m_FilterEditor);
    protected JButton m_ApplyFilterBut = new JButton("Apply");
    protected JButton m_StopBut = new JButton("Stop");
    protected ConverterFileChooser m_FileChooser;
    protected String m_LastURL = "http://";
    protected String m_SQLQ = new String("SELECT * FROM ?");
    protected Instances m_Instances;
    protected DataGenerator m_DataGenerator = null;
    protected AttributeVisualizationPanel m_AttVisualizePanel = new AttributeVisualizationPanel();
    protected File[] m_tempUndoFiles = new File[20];
    protected int m_tempUndoIndex = 0;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Thread m_IOThread;
    protected Logger m_Log = new SysErrLog();
    protected Explorer m_Explorer = null;
    protected boolean m_initialSettingsSet;
    protected List<JMenu> m_menus = new ArrayList<JMenu>();

    public PreprocessPanel() {
        String initialDir = ExplorerDefaults.getInitialDirectory();
        this.m_FileChooser = new ConverterFileChooser(new File(initialDir));
        this.m_FilterEditor.setClassType(Filter.class);
        if (ExplorerDefaults.getFilter() != null) {
            this.m_FilterEditor.setValue(ExplorerDefaults.getFilter());
        }
        this.m_FilterEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PreprocessPanel.this.m_ApplyFilterBut.setEnabled(PreprocessPanel.this.getInstances() != null);
                Capabilities currentCapabilitiesFilter = PreprocessPanel.this.m_FilterEditor.getCapabilitiesFilter();
                Filter filter = (Filter)PreprocessPanel.this.m_FilterEditor.getValue();
                Capabilities currentFilterCapabilities = null;
                if (filter != null && currentCapabilitiesFilter != null && filter instanceof CapabilitiesHandler && !(currentFilterCapabilities = filter.getCapabilities()).supportsMaybe(currentCapabilitiesFilter) && !currentFilterCapabilities.supports(currentCapabilitiesFilter)) {
                    try {
                        filter.setInputFormat(PreprocessPanel.this.getInstances());
                    }
                    catch (Exception ex) {
                        PreprocessPanel.this.m_ApplyFilterBut.setEnabled(false);
                    }
                }
            }
        });
        JMenu fileMenu = new JMenu();
        fileMenu.setText("File");
        this.m_menus.add(fileMenu);
        this.m_OpenFileBut.setToolTipText("Open a set of instances from a file");
        JMenuItem openFileM = new JMenuItem("Open file...");
        openFileM.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        fileMenu.add(openFileM);
        this.m_OpenURLBut.setToolTipText("Open a set of instances from a URL");
        JMenuItem openURLM = new JMenuItem("Open URL...");
        openURLM.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        fileMenu.add(openURLM);
        this.m_OpenDBBut.setToolTipText("Open a set of instances from a database");
        JMenuItem openDBM = new JMenuItem("Open DB...");
        openDBM.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        fileMenu.add(openDBM);
        this.m_GenerateBut.setToolTipText("Generates artificial data");
        JMenuItem generateM = new JMenuItem("Generate...");
        generateM.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.m_UndoBut.setToolTipText("Undo the last change to the dataset");
        fileMenu.add(generateM);
        this.m_UndoBut.setEnabled(ExplorerDefaults.get("enableUndo", "true").equalsIgnoreCase("true"));
        if (!this.m_UndoBut.isEnabled()) {
            this.m_UndoBut.setToolTipText("Undo is disabled - see weka.gui.explorer.Explorer.props to enable");
        }
        this.m_EditBut.setToolTipText("Open the current dataset in a Viewer for editing");
        JMenu editMenu = new JMenu();
        editMenu.add(this.m_EditM);
        this.m_EditM.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        this.m_EditM.setEnabled(false);
        editMenu.setText("Edit");
        this.m_menus.add(editMenu);
        this.m_SaveBut.setToolTipText("Save the working relation to a file");
        this.m_ApplyFilterBut.setToolTipText("Apply the current filter to the data");
        this.m_StopBut.setToolTipText("Stop the filtering process");
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_OpenURLBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.setInstancesFromURLQ();
            }
        });
        openURLM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.setInstancesFromURLQ();
            }
        });
        this.m_OpenDBBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = null;
                Window window = SwingUtilities.getWindowAncestor(PreprocessPanel.this);
                if (window instanceof JFrame) {
                    frame = (JFrame)window;
                }
                SqlViewerDialog dialog = new SqlViewerDialog(frame);
                dialog.pack();
                dialog.setSize(800, 700);
                dialog.setIconImage(((Frame)SwingUtilities.getWindowAncestor(PreprocessPanel.this)).getIconImage());
                dialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor(PreprocessPanel.this));
                dialog.setVisible(true);
                if (dialog.getReturnValue() == 0) {
                    PreprocessPanel.this.setInstancesFromDBQ(dialog.getURL(), dialog.getUser(), dialog.getPassword(), dialog.getQuery(), dialog.getGenerateSparseData());
                }
            }
        });
        this.m_OpenFileBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.setInstancesFromFileQ();
            }
        });
        openFileM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.setInstancesFromFileQ();
            }
        });
        this.m_GenerateBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.generateInstances();
            }
        });
        generateM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.generateInstances();
            }
        });
        this.m_UndoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.undo();
            }
        });
        this.m_EditBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.edit();
            }
        });
        this.m_EditM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.edit();
            }
        });
        this.m_SaveBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.saveWorkingInstancesToFileQ();
            }
        });
        this.m_ApplyFilterBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.applyFilter((Filter)PreprocessPanel.this.m_FilterEditor.getValue());
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreprocessPanel.this.m_IOThread != null) {
                    PreprocessPanel.this.m_IOThread.stop();
                    PreprocessPanel.this.m_StopBut.setEnabled(false);
                    PreprocessPanel.this.m_IOThread = null;
                    if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                        ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                    }
                    PreprocessPanel.this.m_Log.statusMessage("Filtering process stopped prematurely");
                }
            }
        });
        this.m_AttPanel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (!lm.isSelectedIndex(i)) continue;
                        PreprocessPanel.this.m_AttSummaryPanel.setAttribute(i);
                        PreprocessPanel.this.m_AttVisualizePanel.setAttribute(i);
                        break;
                    }
                }
            }
        });
        this.m_InstSummaryPanel.setBorder(BorderFactory.createTitledBorder("Current relation"));
        JPanel attStuffHolderPanel = new JPanel();
        attStuffHolderPanel.setBorder(BorderFactory.createTitledBorder("Attributes"));
        attStuffHolderPanel.setLayout(new BorderLayout());
        attStuffHolderPanel.add((Component)this.m_AttPanel, "Center");
        this.m_RemoveButton.setEnabled(false);
        this.m_RemoveButton.setToolTipText("Remove selected attributes.");
        this.m_RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Remove r = new Remove();
                    int[] selected = PreprocessPanel.this.m_AttPanel.getSelectedAttributes();
                    if (selected.length == 0) {
                        return;
                    }
                    if (selected.length == PreprocessPanel.this.m_Instances.numAttributes()) {
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Can't remove all attributes from data!\n", "Remove Attributes", 0);
                        PreprocessPanel.this.m_Log.logMessage("Can't remove all attributes from data!");
                        PreprocessPanel.this.m_Log.statusMessage("Problem removing attributes");
                        return;
                    }
                    r.setAttributeIndicesArray(selected);
                    PreprocessPanel.this.applyFilter(r);
                    PreprocessPanel.this.m_RemoveButton.setEnabled(false);
                }
                catch (Exception ex) {
                    if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                        ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                    }
                    JOptionPane.showMessageDialog(PreprocessPanel.this, "Problem filtering instances:\n" + ex.getMessage(), "Remove Attributes", 0);
                    PreprocessPanel.this.m_Log.logMessage("Problem removing attributes: " + ex.getMessage());
                    PreprocessPanel.this.m_Log.statusMessage("Problem removing attributes");
                    ex.printStackTrace();
                }
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_RemoveButton, "Center");
        attStuffHolderPanel.add((Component)p1, "South");
        this.m_AttSummaryPanel.setBorder(BorderFactory.createTitledBorder("Selected attribute"));
        this.m_UndoBut.setEnabled(false);
        this.m_EditBut.setEnabled(false);
        this.m_SaveBut.setEnabled(false);
        this.m_ApplyFilterBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        JPanel buttons = new JPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(new GridLayout(1, 6, 5, 5));
        buttons.add(this.m_OpenFileBut);
        buttons.add(this.m_OpenURLBut);
        buttons.add(this.m_OpenDBBut);
        buttons.add(this.m_GenerateBut);
        buttons.add(this.m_UndoBut);
        buttons.add(this.m_EditBut);
        buttons.add(this.m_SaveBut);
        JPanel attInfo = new JPanel();
        attInfo.setLayout(new BorderLayout());
        attInfo.add((Component)attStuffHolderPanel, "Center");
        JPanel filter = new JPanel();
        filter.setBorder(BorderFactory.createTitledBorder("Filter"));
        filter.setLayout(new BorderLayout());
        filter.add((Component)this.m_FilterPanel, "Center");
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ssButs.setLayout(new GridLayout(1, 2, 2, 0));
        ssButs.add(this.m_ApplyFilterBut);
        ssButs.add(this.m_StopBut);
        filter.add((Component)ssButs, "East");
        JPanel attVis = new JPanel();
        attVis.setLayout(new GridLayout(2, 1));
        attVis.add(this.m_AttSummaryPanel);
        JComboBox colorBox = this.m_AttVisualizePanel.getColorBox();
        colorBox.setToolTipText("The chosen attribute will also be used as the class attribute when a filter is applied.");
        colorBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    PreprocessPanel.this.updateCapabilitiesFilter(PreprocessPanel.this.m_FilterEditor.getCapabilitiesFilter());
                }
            }
        });
        final JButton visAllBut = new JButton("Visualize All");
        visAllBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PreprocessPanel.this.m_Instances != null) {
                    try {
                        AttributeSummarizer as = new AttributeSummarizer();
                        as.setColoringIndex(PreprocessPanel.this.m_AttVisualizePanel.getColoringIndex());
                        as.setInstances(PreprocessPanel.this.m_Instances);
                        final JFrame jf = Utils.getWekaJFrame("All attributes", PreprocessPanel.this);
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)as, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                visAllBut.setEnabled(true);
                                jf.dispose();
                            }
                        });
                        jf.pack();
                        jf.setSize(1000, 600);
                        jf.setLocationRelativeTo(SwingUtilities.getWindowAncestor(PreprocessPanel.this));
                        jf.setVisible(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JPanel histoHolder = new JPanel();
        histoHolder.setLayout(new BorderLayout());
        histoHolder.add((Component)this.m_AttVisualizePanel, "Center");
        JPanel histoControls = new JPanel();
        histoControls.setLayout(new BorderLayout());
        histoControls.add((Component)colorBox, "Center");
        histoControls.add((Component)visAllBut, "East");
        histoHolder.add((Component)histoControls, "North");
        attVis.add(histoHolder);
        JPanel lhs = new JPanel();
        lhs.setLayout(new BorderLayout());
        lhs.add((Component)this.m_InstSummaryPanel, "North");
        lhs.add((Component)attInfo, "Center");
        JPanel rhs = new JPanel();
        rhs.setLayout(new BorderLayout());
        rhs.add((Component)attVis, "Center");
        JPanel relation = new JPanel();
        relation.setLayout(new GridLayout(1, 2));
        relation.add(lhs);
        relation.add(rhs);
        JPanel middle = new JPanel();
        middle.setLayout(new BorderLayout());
        middle.add((Component)filter, "North");
        middle.add((Component)relation, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)buttons, "North");
        this.add((Component)middle, "Center");
    }

    @Override
    public boolean acceptsInstances() {
        return true;
    }

    @Override
    public void instantiationComplete() {
        boolean sendToAll = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL_KEY, Boolean.valueOf(PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL), Environment.getSystemWide());
        final ArrayList<Perspective> perspectivesThatAcceptInstances = new ArrayList<Perspective>();
        List<Perspective> visiblePerspectives = this.getMainApplication().getPerspectiveManager().getVisiblePerspectives();
        for (Perspective p : visiblePerspectives) {
            if (!p.acceptsInstances() || p.getPerspectiveID().equals(this.getPerspectiveID())) continue;
            perspectivesThatAcceptInstances.add(p);
        }
        if (perspectivesThatAcceptInstances.size() > 0) {
            JMenu fileMenu = this.m_menus.get(0);
            this.m_sendToPerspective = new JMenu();
            this.m_sendToPerspective.setText("Send to perspective");
            fileMenu.add(this.m_sendToPerspective);
            if (!sendToAll) {
                this.m_sendToPerspective.setEnabled(false);
            }
            JMenuItem sendToAllItem = new JMenuItem("All perspectives");
            sendToAllItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Perspective p : perspectivesThatAcceptInstances) {
                        if (PreprocessPanel.this.getInstances() == null || !p.acceptsInstances()) continue;
                        p.setInstances(PreprocessPanel.this.getInstances());
                        PreprocessPanel.this.getMainApplication().getPerspectiveManager().setEnablePerspectiveTab(p.getPerspectiveID(), true);
                    }
                }
            });
            this.m_sendToPerspective.add(sendToAllItem);
            for (final Perspective p : perspectivesThatAcceptInstances) {
                JMenuItem item = new JMenuItem(p.getPerspectiveTitle());
                this.m_sendToPerspective.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (PreprocessPanel.this.getInstances() != null) {
                            p.setInstances(PreprocessPanel.this.getInstances());
                            PreprocessPanel.this.getMainApplication().getPerspectiveManager().setEnablePerspectiveTab(p.getPerspectiveID(), true);
                            PreprocessPanel.this.getMainApplication().getPerspectiveManager().setActivePerspective(p.getPerspectiveID());
                        }
                    }
                });
            }
        }
    }

    @Override
    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    @Override
    public boolean requiresLog() {
        return true;
    }

    @Override
    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    boolean sendToAll;
                    boolean first = PreprocessPanel.this.m_AttPanel.getTableModel() == null;
                    PreprocessPanel.this.m_InstSummaryPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttPanel.setInstances(PreprocessPanel.this.m_Instances);
                    if (first) {
                        TableModel model = PreprocessPanel.this.m_AttPanel.getTableModel();
                        model.addTableModelListener(new TableModelListener(){

                            @Override
                            public void tableChanged(TableModelEvent e) {
                                if (PreprocessPanel.this.m_AttPanel.getSelectedAttributes() != null && PreprocessPanel.this.m_AttPanel.getSelectedAttributes().length > 0) {
                                    PreprocessPanel.this.m_RemoveButton.setEnabled(true);
                                } else {
                                    PreprocessPanel.this.m_RemoveButton.setEnabled(false);
                                }
                            }
                        });
                    }
                    PreprocessPanel.this.m_AttSummaryPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttVisualizePanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttPanel.getSelectionModel().setSelectionInterval(0, 0);
                    PreprocessPanel.this.m_AttSummaryPanel.setAttribute(0);
                    PreprocessPanel.this.m_AttVisualizePanel.setAttribute(0);
                    PreprocessPanel.this.m_ApplyFilterBut.setEnabled(true);
                    PreprocessPanel.this.m_StopBut.setEnabled(false);
                    PreprocessPanel.this.m_Log.logMessage("Base relation is now " + PreprocessPanel.this.m_Instances.relationName() + " (" + PreprocessPanel.this.m_Instances.numInstances() + " instances)");
                    PreprocessPanel.this.m_SaveBut.setEnabled(true);
                    PreprocessPanel.this.m_EditBut.setEnabled(true);
                    PreprocessPanel.this.m_EditM.setEnabled(true);
                    PreprocessPanel.this.m_Log.statusMessage("OK");
                    PreprocessPanel.this.m_Support.firePropertyChange("", null, null);
                    boolean bl = sendToAll = PreprocessPanel.this.getExplorer() != null || PreprocessPanel.this.getMainApplication().getApplicationSettings().getSetting(PreprocessPanel.this.getPerspectiveID(), PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL_KEY, Boolean.valueOf(PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL), Environment.getSystemWide()) != false;
                    if (PreprocessPanel.this.m_sendToPerspective != null) {
                        PreprocessPanel.this.m_sendToPerspective.setEnabled(!sendToAll);
                    }
                    if (PreprocessPanel.this.getMainApplication() != null && sendToAll) {
                        List<Perspective> perspectiveList = PreprocessPanel.this.getMainApplication().getPerspectiveManager().getVisiblePerspectives();
                        for (Perspective p : perspectiveList) {
                            if (!p.acceptsInstances() || p.getPerspectiveID().equals(PreprocessPanel.this.getPerspectiveID())) continue;
                            p.setInstances(PreprocessPanel.this.m_Instances);
                        }
                    }
                    if (PreprocessPanel.this.getExplorer() != null || PreprocessPanel.this.getMainApplication() != null) {
                        Explorer explorer = PreprocessPanel.this.getExplorer();
                        WorkbenchApp app = (WorkbenchApp)PreprocessPanel.this.getMainApplication();
                        try {
                            if (explorer != null) {
                                explorer.notifyCapabilitiesFilterListener(null);
                            } else {
                                app.notifyCapabilitiesFilterListeners(null);
                                if (sendToAll) {
                                    app.getPerspectiveManager().enableAllPerspectiveTabs();
                                }
                            }
                            int oldIndex = PreprocessPanel.this.m_Instances.classIndex();
                            PreprocessPanel.this.m_Instances.setClassIndex(PreprocessPanel.this.m_AttVisualizePanel.getColorBox().getSelectedIndex() - 1);
                            if (ExplorerDefaults.getInitGenericObjectEditorFilter()) {
                                if (explorer != null) {
                                    explorer.notifyCapabilitiesFilterListener(Capabilities.forInstances(PreprocessPanel.this.m_Instances));
                                } else if (sendToAll) {
                                    app.notifyCapabilitiesFilterListeners(Capabilities.forInstances(PreprocessPanel.this.m_Instances));
                                }
                            } else if (explorer != null) {
                                explorer.notifyCapabilitiesFilterListener(Capabilities.forInstances(new Instances(PreprocessPanel.this.m_Instances, 0)));
                            } else if (sendToAll) {
                                app.notifyCapabilitiesFilterListeners(Capabilities.forInstances(new Instances(PreprocessPanel.this.m_Instances, 0)));
                            }
                            PreprocessPanel.this.m_Instances.setClassIndex(oldIndex);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            PreprocessPanel.this.m_Log.logMessage(e.toString());
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Problem setting base instances:\n" + ex, "Instances", 0);
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.m_Support != null && l != null) {
            this.m_Support.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.m_Support != null && l != null) {
            this.m_Support.removePropertyChangeListener(l);
        }
    }

    protected void applyFilter(final Filter filter) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        if (filter != null) {
                            PreprocessPanel.this.m_FilterPanel.addToHistory();
                            if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskStarted();
                            }
                            PreprocessPanel.this.m_Log.statusMessage("Passing dataset through filter " + filter.getClass().getName());
                            String cmd = filter.getClass().getName();
                            if (filter instanceof OptionHandler) {
                                cmd = cmd + " " + Utils.joinOptions(filter.getOptions());
                            }
                            PreprocessPanel.this.m_Log.logMessage("Command: " + cmd);
                            int classIndex = PreprocessPanel.this.m_AttVisualizePanel.getColoringIndex();
                            if (classIndex < 0 && filter instanceof SupervisedFilter) {
                                throw new IllegalArgumentException("Class (colour) needs to be set for supervised filter.");
                            }
                            Instances copy = new Instances(PreprocessPanel.this.m_Instances);
                            copy.setClassIndex(classIndex);
                            PreprocessPanel.this.m_StopBut.setEnabled(true);
                            Filter filterCopy = Filter.makeCopy(filter);
                            filterCopy.setInputFormat(copy);
                            Instances newInstances = Filter.useFilter(copy, filterCopy);
                            PreprocessPanel.this.m_StopBut.setEnabled(false);
                            if (newInstances == null || newInstances.numAttributes() < 1) {
                                throw new Exception("Dataset is empty.");
                            }
                            PreprocessPanel.this.m_Log.statusMessage("Saving undo information");
                            PreprocessPanel.this.addUndoPoint();
                            PreprocessPanel.this.m_AttVisualizePanel.setColoringIndex(copy.classIndex());
                            if (PreprocessPanel.this.m_Instances.classIndex() < 0) {
                                newInstances.setClassIndex(-1);
                            }
                            PreprocessPanel.this.m_Instances = newInstances;
                            PreprocessPanel.this.setInstances(PreprocessPanel.this.m_Instances);
                            if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                        }
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Problem filtering instances:\n" + ex.getMessage(), "Apply Filter", 0);
                        PreprocessPanel.this.m_Log.logMessage("Problem filtering instances: " + ex.getMessage());
                        PreprocessPanel.this.m_Log.statusMessage("Problem filtering instances");
                        ex.printStackTrace();
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't apply filter at this time,\ncurrently busy with other IO", "Apply Filter", 2);
        }
    }

    public void saveWorkingInstancesToFileQ() {
        if (this.m_IOThread == null) {
            this.m_FileChooser.setCapabilitiesFilter(this.m_FilterEditor.getCapabilitiesFilter());
            this.m_FileChooser.setAcceptAllFileFilterUsed(false);
            int returnVal = this.m_FileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                Instances inst = new Instances(this.m_Instances);
                inst.setClassIndex(this.m_AttVisualizePanel.getColoringIndex());
                this.saveInstancesToFile(this.m_FileChooser.getSaver(), inst);
            }
            FileFilter temp = this.m_FileChooser.getFileFilter();
            this.m_FileChooser.setAcceptAllFileFilterUsed(true);
            this.m_FileChooser.setFileFilter(temp);
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Save Instances", 2);
        }
    }

    public void saveInstancesToFile(final AbstractFileSaver saver, final Instances inst) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Saving to file...");
                        saver.setInstances(inst);
                        saver.writeBatch();
                        PreprocessPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(ex.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Saving instances", 2);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int returnVal = this.m_FileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    this.addUndoPoint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_FileChooser.getLoader() == null) {
                    JOptionPane.showMessageDialog(this, "Cannot determine file loader automatically, please choose one.", "Load Instances", 0);
                    this.converterQuery(this.m_FileChooser.getSelectedFile());
                } else {
                    this.setInstancesFromFile(this.m_FileChooser.getLoader());
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromDBQ(String url, String user, String pw, String query) {
        this.setInstancesFromDBQ(url, user, pw, query, false);
    }

    public void setInstancesFromDBQ(String url, String user, String pw, String query, boolean sparse) {
        if (this.m_IOThread == null) {
            try {
                InstanceQuery InstQ = new InstanceQuery();
                InstQ.setDatabaseURL(url);
                InstQ.setUsername(user);
                InstQ.setPassword(pw);
                InstQ.setQuery(query);
                InstQ.setSparseData(sparse);
                if (InstQ.isConnected()) {
                    InstQ.disconnectFromDatabase();
                }
                InstQ.connectToDatabase();
                try {
                    this.addUndoPoint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setInstancesFromDB(InstQ);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Problem connecting to database:\n" + ex.getMessage(), "Load Instances", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURLQ() {
        block6: {
            if (this.m_IOThread == null) {
                try {
                    String urlName = (String)JOptionPane.showInputDialog(this, "Enter the source URL", "Load Instances", 3, null, null, this.m_LastURL);
                    if (urlName == null) break block6;
                    this.m_LastURL = urlName;
                    URL url = new URL(urlName);
                    try {
                        this.addUndoPoint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setInstancesFromURL(url);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Problem with URL:\n" + ex.getMessage(), "Load Instances", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
            }
        }
    }

    public void generateInstances() {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        final DataGeneratorPanel generatorPanel = new DataGeneratorPanel();
                        final JDialog dialog = new JDialog();
                        JButton generateButton = new JButton("Generate");
                        final JCheckBox showOutputCheckBox = new JCheckBox("Show generated data as text, incl. comments");
                        showOutputCheckBox.setMnemonic('S');
                        generatorPanel.setLog(PreprocessPanel.this.m_Log);
                        generatorPanel.setGenerator(PreprocessPanel.this.m_DataGenerator);
                        generatorPanel.setPreferredSize(new Dimension(300, (int)generatorPanel.getPreferredSize().getHeight()));
                        generateButton.setMnemonic('G');
                        generateButton.setToolTipText("Generates the dataset according the settings.");
                        generateButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                boolean generated;
                                boolean showOutput = showOutputCheckBox.isSelected();
                                generatorPanel.execute(showOutput);
                                boolean bl = generated = generatorPanel.getInstances() != null;
                                if (generated) {
                                    PreprocessPanel.this.setInstances(generatorPanel.getInstances());
                                }
                                dialog.dispose();
                                PreprocessPanel.this.m_DataGenerator = generatorPanel.getGenerator();
                                if (generated && showOutput) {
                                    PreprocessPanel.this.showGeneratedInstances(generatorPanel.getOutput());
                                }
                            }
                        });
                        dialog.setTitle("DataGenerator");
                        dialog.getContentPane().add((Component)generatorPanel, "Center");
                        dialog.getContentPane().add((Component)generateButton, "East");
                        dialog.getContentPane().add((Component)showOutputCheckBox, "South");
                        dialog.pack();
                        dialog.setSize(1000, 130);
                        dialog.setIconImage(((Frame)SwingUtilities.getWindowAncestor(PreprocessPanel.this)).getIconImage());
                        dialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor(PreprocessPanel.this));
                        dialog.setVisible(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(ex.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't generate data at this time,\ncurrently busy with other IO", "Generate Data", 2);
        }
    }

    protected void showGeneratedInstances(String data) {
        final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(this));
        JButton saveButton = new JButton("Save");
        JButton closeButton = new JButton("Close");
        final JTextArea textData = new JTextArea(data);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        textData.setEditable(false);
        textData.setFont(new Font("Monospaced", 0, textData.getFont().getSize()));
        saveButton.setMnemonic('S');
        saveButton.setToolTipText("Saves the output to a file");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser filechooser = new JFileChooser();
                int result = filechooser.showSaveDialog(dialog);
                if (result == 0) {
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(filechooser.getSelectedFile()));
                        writer.write(textData.getText());
                        writer.flush();
                        writer.close();
                        JOptionPane.showMessageDialog(dialog, "Output successfully saved to file '" + filechooser.getSelectedFile() + "'!", "Information", 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    dialog.dispose();
                }
            }
        });
        closeButton.setMnemonic('C');
        closeButton.setToolTipText("Closes the dialog");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dialog.dispose();
            }
        });
        panel.add(saveButton);
        panel.add(closeButton);
        dialog.setTitle("Generated Instances (incl. comments)");
        dialog.getContentPane().add((Component)new JScrollPane(textData), "Center");
        dialog.getContentPane().add((Component)panel, "South");
        dialog.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (double)dialog.getWidth() > screen.getWidth() * 0.8 ? (int)(screen.getWidth() * 0.8) : dialog.getWidth();
        int height = (double)dialog.getHeight() > screen.getHeight() * 0.8 ? (int)(screen.getHeight() * 0.8) : dialog.getHeight();
        dialog.setSize(width, height);
        dialog.pack();
        dialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
        dialog.setVisible(true);
    }

    private void converterQuery(final File f) {
        final GenericObjectEditor convEd = new GenericObjectEditor(true);
        try {
            convEd.setClassType(Loader.class);
            convEd.setValue(new CSVLoader());
            ((GenericObjectEditor.GOEPanel)convEd.getCustomEditor()).addOkListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreprocessPanel.this.tryConverter((Loader)convEd.getValue(), f);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        PropertyDialog pd = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)convEd, -1, -1) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)convEd, -1, -1);
        pd.setVisible(true);
    }

    private void tryConverter(final Loader cnv, final File f) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        cnv.setSource(f);
                        Instances inst = cnv.getDataSet();
                        PreprocessPanel.this.setInstances(inst);
                    }
                    catch (Exception ex) {
                        PreprocessPanel.this.m_Log.statusMessage(cnv.getClass().getName() + " failed to load " + f.getName());
                        JOptionPane.showMessageDialog(PreprocessPanel.this, cnv.getClass().getName() + " failed to load '" + f.getName() + "'.\nReason:\n" + ex.getMessage(), "Convert File", 0);
                        PreprocessPanel.this.m_IOThread = null;
                        PreprocessPanel.this.converterQuery(f);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        }
    }

    public void setInstancesFromFile(final AbstractFileLoader loader) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    block2: {
                        try {
                            PreprocessPanel.this.m_Log.statusMessage("Reading from file...");
                            Instances inst = loader.getDataSet();
                            PreprocessPanel.this.setInstances(inst);
                        }
                        catch (Exception ex) {
                            PreprocessPanel.this.m_Log.statusMessage("File '" + loader.retrieveFile() + "' not recognised as an '" + loader.getFileDescription() + "' file.");
                            PreprocessPanel.this.m_IOThread = null;
                            if (JOptionPane.showOptionDialog(PreprocessPanel.this, "File '" + loader.retrieveFile() + "' not recognised as an '" + loader.getFileDescription() + "' file.\nReason:\n" + ex.getMessage(), "Load Instances", 0, 0, null, new String[]{"OK", "Use Converter"}, null) != 1) break block2;
                            PreprocessPanel.this.converterQuery(loader.retrieveFile());
                        }
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromDB(final InstanceQuery iq) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Reading from database...");
                        final Instances i = iq.retrieveInstances();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                PreprocessPanel.this.setInstances(new Instances(i));
                            }
                        });
                        iq.disconnectFromDatabase();
                    }
                    catch (Exception ex) {
                        PreprocessPanel.this.m_Log.statusMessage("Problem executing DB query " + PreprocessPanel.this.m_SQLQ);
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Couldn't read from database:\n" + ex.getMessage(), "Load Instances", 0);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURL(final URL u) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Reading from URL...");
                        AbstractFileLoader loader = ConverterUtils.getURLLoaderForFile(u.toString());
                        if (loader == null) {
                            throw new Exception("No suitable URLSourcedLoader found for URL!\n" + u);
                        }
                        ((URLSourcedLoader)((Object)loader)).setURL(u.toString());
                        PreprocessPanel.this.setInstances(loader.getDataSet());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        PreprocessPanel.this.m_Log.statusMessage("Problem reading " + u);
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Couldn't read from URL:\n" + u + "\n" + ex.getMessage(), "Load Instances", 0);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void addUndoPoint() throws Exception {
        boolean undoEnabled;
        if (!ExplorerDefaults.get("enableUndo", "true").equalsIgnoreCase("true")) {
            return;
        }
        if (this.getMainApplication() != null && !(undoEnabled = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), PreprocessDefaults.ENABLE_UNDO_KEY, PreprocessDefaults.ENABLE_UNDO, Environment.getSystemWide()).booleanValue())) {
            return;
        }
        if (this.m_Instances != null) {
            File tempFile = File.createTempFile("weka", SerializedInstancesLoader.FILE_EXTENSION);
            tempFile.deleteOnExit();
            boolean nonDefaultTmpDir = false;
            String dir = "";
            if (this.getMainApplication() != null) {
                dir = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), PreprocessDefaults.UNDO_DIR_KEY, PreprocessDefaults.UNDO_DIR).toString();
                Environment.getSystemWide();
                if (Environment.containsEnvVariables(dir)) {
                    dir = Environment.getSystemWide().substitute(dir);
                }
                if (!dir.equals(PreprocessDefaults.UNDO_DIR)) {
                    nonDefaultTmpDir = true;
                }
            } else if (!ExplorerDefaults.get("undoDirectory", "%t").equalsIgnoreCase("%t")) {
                nonDefaultTmpDir = true;
                dir = ExplorerDefaults.get("undoDirectory", "%t");
            }
            if (nonDefaultTmpDir) {
                File undoDir = new File(dir);
                if (undoDir.exists()) {
                    String fileName = tempFile.getName();
                    File newFile = new File(dir + File.separator + fileName);
                    if (undoDir.canWrite()) {
                        newFile.deleteOnExit();
                        tempFile = newFile;
                    } else {
                        System.err.println("Explorer: it doesn't look like we have permission to write to the user-specified undo directory '" + dir + "'");
                    }
                } else {
                    System.err.println("Explorer: user-specified undo directory '" + dir + "' does not exist!");
                }
            }
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
            oos.writeObject(this.m_Instances);
            oos.flush();
            oos.close();
            if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
                this.m_tempUndoFiles[this.m_tempUndoIndex].delete();
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = tempFile;
            if (++this.m_tempUndoIndex >= this.m_tempUndoFiles.length) {
                this.m_tempUndoIndex = 0;
            }
            this.m_UndoBut.setEnabled(true);
        }
    }

    public void undo() {
        int temp;
        if (--this.m_tempUndoIndex < 0) {
            this.m_tempUndoIndex = this.m_tempUndoFiles.length - 1;
        }
        if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
            AbstractFileLoader loader = ConverterUtils.getLoaderForFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
            try {
                loader.setFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
                this.setInstancesFromFile(loader);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_Log.logMessage(e.toString());
                JOptionPane.showMessageDialog(this, "Cannot perform undo operation!\n" + e.toString(), "Undo", 0);
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = null;
        }
        if ((temp = this.m_tempUndoIndex - 1) < 0) {
            temp = this.m_tempUndoFiles.length - 1;
        }
        this.m_UndoBut.setEnabled(this.m_tempUndoFiles[temp] != null);
    }

    public void edit() {
        int classIndex = this.m_AttVisualizePanel.getColoringIndex();
        Instances copy = new Instances(this.m_Instances);
        copy.setClassIndex(classIndex);
        ViewerDialog dialog = new ViewerDialog(null);
        dialog.pack();
        dialog.setSize(1000, 600);
        dialog.setIconImage(((Frame)SwingUtilities.getWindowAncestor(this)).getIconImage());
        dialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
        int result = dialog.showDialog(copy);
        if (result == 0) {
            try {
                this.addUndoPoint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Instances newInstances = dialog.getInstances();
            if (this.m_Instances.classIndex() < 0) {
                newInstances.setClassIndex(-1);
            }
            this.setInstances(newInstances);
        }
    }

    @Override
    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    @Override
    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_FilterEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(this.m_AttVisualizePanel.getColorBox().getSelectedIndex() - 1);
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_FilterEditor.setCapabilitiesFilter(filterClass);
        this.m_ApplyFilterBut.setEnabled(true);
        Capabilities currentCapabilitiesFilter = this.m_FilterEditor.getCapabilitiesFilter();
        Filter currentFilter = (Filter)this.m_FilterEditor.getValue();
        Capabilities currentFilterCapabilities = null;
        if (currentFilter != null && currentCapabilitiesFilter != null && currentFilter instanceof CapabilitiesHandler && !(currentFilterCapabilities = currentFilter.getCapabilities()).supportsMaybe(currentCapabilitiesFilter) && !currentFilterCapabilities.supports(currentCapabilitiesFilter)) {
            try {
                currentFilter.setInputFormat(this.getInstances());
            }
            catch (Exception ex) {
                this.m_ApplyFilterBut.setEnabled(false);
            }
        }
    }

    @Override
    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    @Override
    public String getTabTitle() {
        return "Preprocess";
    }

    @Override
    public String getTabTitleToolTip() {
        return "Open/Edit/Save instances";
    }

    @Override
    public Defaults getDefaultSettings() {
        return new PreprocessDefaults();
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.m_isActive) {
            this.updateSettings();
        }
    }

    @Override
    public void settingsChanged() {
        this.updateSettings();
    }

    protected void updateSettings() {
        boolean sendToAll;
        File initialDir = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), PreprocessDefaults.INITIAL_DIR_KEY, PreprocessDefaults.INITIAL_DIR, Environment.getSystemWide());
        Environment.getSystemWide();
        if (Environment.containsEnvVariables(initialDir.toString())) {
            String initDir = initialDir.toString();
            try {
                initDir = Environment.getSystemWide().substitute(initDir);
                initialDir = new File(initDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_FileChooser.setCurrentDirectory(initialDir);
        if (!this.m_initialSettingsSet) {
            Filter toUse = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), PreprocessDefaults.FILTER_KEY, PreprocessDefaults.FILTER, Environment.getSystemWide());
            this.m_FilterEditor.setValue(toUse);
            this.m_UndoBut.setEnabled(false);
            this.m_initialSettingsSet = true;
        }
        if ((sendToAll = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL_KEY, Boolean.valueOf(PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL), Environment.getSystemWide()).booleanValue()) && this.getInstances() != null) {
            List<Perspective> visiblePerspectives = this.getMainApplication().getPerspectiveManager().getVisiblePerspectives();
            for (Perspective p : visiblePerspectives) {
                if (!p.okToBeActive() && p.acceptsInstances()) {
                    p.setInstances(this.getInstances());
                }
                if (!p.okToBeActive()) continue;
                this.getMainApplication().getPerspectiveManager().setEnablePerspectiveTab(p.getPerspectiveID(), true);
            }
        }
        if (this.m_sendToPerspective != null) {
            this.m_sendToPerspective.setEnabled(!sendToAll && this.getInstances() != null);
        }
    }

    @Override
    public List<JMenu> getMenus() {
        return this.m_menus;
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Preprocess");
            jf.getContentPane().setLayout(new BorderLayout());
            PreprocessPanel sp = new PreprocessPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static class PreprocessDefaults
    extends Defaults {
        public static final String ID = "weka.gui.explorer.preprocesspanel";
        public static final Settings.SettingKey INITIAL_DIR_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.initialDir", "Initial directory for opening datasets", "");
        public static final File INITIAL_DIR = new File("${user.dir}");
        public static final Settings.SettingKey UNDO_DIR_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.undoDir", "Directory for storing undo files", "");
        public static final File UNDO_DIR = new File("${java.io.tmpdir}");
        public static final Settings.SettingKey FILTER_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.initialFilter", "Initial filter", "");
        public static final Filter FILTER = new AllFilter();
        public static final Settings.SettingKey ENABLE_UNDO_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.enableUndo", "Enable undo", "");
        public static final Boolean ENABLE_UNDO = true;
        public static final Settings.SettingKey ALWAYS_SEND_INSTANCES_TO_ALL_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.alwaysSendInstancesToAllPerspectives", "Always send instances to all perspectives", "");
        public static boolean ALWAYS_SEND_INSTANCES_TO_ALL = true;

        public PreprocessDefaults() {
            super(ID);
            INITIAL_DIR_KEY.setMetadataElement("java.io.File.fileSelectionMode", "1");
            INITIAL_DIR_KEY.setMetadataElement("java.io.File.dialogType", "0");
            UNDO_DIR_KEY.setMetadataElement("java.io.File.fileSelectionMode", "1");
            UNDO_DIR_KEY.setMetadataElement("java.io.File.dialogType", "1");
            this.m_defaults.put(INITIAL_DIR_KEY, INITIAL_DIR);
            this.m_defaults.put(UNDO_DIR_KEY, UNDO_DIR);
            this.m_defaults.put(FILTER_KEY, FILTER);
            this.m_defaults.put(ENABLE_UNDO_KEY, ENABLE_UNDO);
            this.m_defaults.put(ALWAYS_SEND_INSTANCES_TO_ALL_KEY, ALWAYS_SEND_INSTANCES_TO_ALL);
        }
    }
}

