/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.util.Random;
import weka.classifiers.Classifier;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;
import weka.gui.boundaryvisualizer.DataGenerator;
import weka.gui.boundaryvisualizer.RemoteResult;

public class RemoteBoundaryVisualizerSubTask
implements Task {
    private static final long serialVersionUID = -5275252329449241592L;
    private final TaskStatusInfo m_status = new TaskStatusInfo();
    private RemoteResult m_result;
    private int m_rowNumber;
    private int m_panelHeight;
    private int m_panelWidth;
    private Classifier m_classifier;
    private DataGenerator m_dataGenerator;
    private Instances m_trainingData;
    private int m_xAttribute;
    private int m_yAttribute;
    private double m_pixHeight;
    private double m_pixWidth;
    private double m_minX;
    private double m_minY;
    private int m_numOfSamplesPerRegion = 2;
    private int m_numOfSamplesPerGenerator;
    private double m_samplesBase = 2.0;
    private Random m_random;
    private double[] m_weightingAttsValues;
    private boolean[] m_attsToWeightOn;
    private double[] m_vals;
    private double[] m_dist;
    private Instance m_predInst;

    public void setRowNumber(int rn) {
        this.m_rowNumber = rn;
    }

    public void setPanelWidth(int pw) {
        this.m_panelWidth = pw;
    }

    public void setPanelHeight(int ph) {
        this.m_panelHeight = ph;
    }

    public void setPixHeight(double ph) {
        this.m_pixHeight = ph;
    }

    public void setPixWidth(double pw) {
        this.m_pixWidth = pw;
    }

    public void setClassifier(Classifier dc) {
        this.m_classifier = dc;
    }

    public void setDataGenerator(DataGenerator dg) {
        this.m_dataGenerator = dg;
    }

    public void setInstances(Instances i) {
        this.m_trainingData = i;
    }

    public void setMinMaxX(double minx, double maxx) {
        this.m_minX = minx;
    }

    public void setMinMaxY(double miny, double maxy) {
        this.m_minY = miny;
    }

    public void setXAttribute(int xatt) {
        this.m_xAttribute = xatt;
    }

    public void setYAttribute(int yatt) {
        this.m_yAttribute = yatt;
    }

    public void setNumSamplesPerRegion(int num) {
        this.m_numOfSamplesPerRegion = num;
    }

    public void setGeneratorSamplesBase(double ksb) {
        this.m_samplesBase = ksb;
    }

    @Override
    public void execute() {
        this.m_random = new Random(this.m_rowNumber * 11);
        this.m_dataGenerator.setSeed(this.m_rowNumber * 11);
        this.m_result = new RemoteResult(this.m_rowNumber, this.m_panelWidth);
        this.m_status.setTaskResult(this.m_result);
        this.m_status.setExecutionStatus(1);
        try {
            this.m_numOfSamplesPerGenerator = (int)Math.pow(this.m_samplesBase, this.m_trainingData.numAttributes() - 3);
            if (this.m_trainingData == null) {
                throw new Exception("No training data set (BoundaryPanel)");
            }
            if (this.m_classifier == null) {
                throw new Exception("No classifier set (BoundaryPanel)");
            }
            if (this.m_dataGenerator == null) {
                throw new Exception("No data generator set (BoundaryPanel)");
            }
            if (this.m_trainingData.attribute(this.m_xAttribute).isNominal() || this.m_trainingData.attribute(this.m_yAttribute).isNominal()) {
                throw new Exception("Visualization dimensions must be numeric (RemoteBoundaryVisualizerSubTask)");
            }
            this.m_attsToWeightOn = new boolean[this.m_trainingData.numAttributes()];
            this.m_attsToWeightOn[this.m_xAttribute] = true;
            this.m_attsToWeightOn[this.m_yAttribute] = true;
            this.m_weightingAttsValues = new double[this.m_attsToWeightOn.length];
            this.m_vals = new double[this.m_trainingData.numAttributes()];
            this.m_predInst = new DenseInstance(1.0, this.m_vals);
            this.m_predInst.setDataset(this.m_trainingData);
            System.err.println("Executing row number " + this.m_rowNumber);
            for (int j = 0; j < this.m_panelWidth; ++j) {
                double[] preds = this.calculateRegionProbs(j, this.m_rowNumber);
                this.m_result.setLocationProbs(j, preds);
                this.m_result.setPercentCompleted((int)(100.0 * ((double)j / (double)this.m_panelWidth)));
            }
        }
        catch (Exception ex) {
            this.m_status.setExecutionStatus(2);
            this.m_status.setStatusMessage("Row " + this.m_rowNumber + " failed.");
            System.err.print(ex);
            return;
        }
        this.m_status.setExecutionStatus(3);
        this.m_status.setStatusMessage("Row " + this.m_rowNumber + " completed successfully.");
    }

    private double[] calculateRegionProbs(int j, int i) throws Exception {
        double[] sumOfProbsForRegion = new double[this.m_trainingData.classAttribute().numValues()];
        for (int u = 0; u < this.m_numOfSamplesPerRegion; ++u) {
            int z;
            double[] sumOfProbsForLocation = new double[this.m_trainingData.classAttribute().numValues()];
            this.m_weightingAttsValues[this.m_xAttribute] = this.getRandomX(j);
            this.m_weightingAttsValues[this.m_yAttribute] = this.getRandomY(this.m_panelHeight - i - 1);
            this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
            double[] weights = this.m_dataGenerator.getWeights();
            double sumOfWeights = Utils.sum(weights);
            int[] indices = Utils.sort(weights);
            int[] newIndices = new int[indices.length];
            double sumSoFar = 0.0;
            double criticalMass = 0.99 * sumOfWeights;
            int index = weights.length - 1;
            int counter = 0;
            for (z = weights.length - 1; z >= 0; --z) {
                newIndices[index--] = indices[z];
                ++counter;
                if ((sumSoFar += weights[indices[z]]) > criticalMass) break;
            }
            indices = new int[counter];
            System.arraycopy(newIndices, index + 1, indices, 0, counter);
            for (z = 0; z < this.m_numOfSamplesPerGenerator; ++z) {
                this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
                double[][] values = this.m_dataGenerator.generateInstances(indices);
                for (int q = 0; q < values.length; ++q) {
                    if (values[q] == null) continue;
                    System.arraycopy(values[q], 0, this.m_vals, 0, this.m_vals.length);
                    this.m_vals[this.m_xAttribute] = this.m_weightingAttsValues[this.m_xAttribute];
                    this.m_vals[this.m_yAttribute] = this.m_weightingAttsValues[this.m_yAttribute];
                    this.m_dist = this.m_classifier.distributionForInstance(this.m_predInst);
                    for (int k = 0; k < sumOfProbsForLocation.length; ++k) {
                        int n = k;
                        sumOfProbsForLocation[n] = sumOfProbsForLocation[n] + this.m_dist[k] * weights[q];
                    }
                }
            }
            for (int k = 0; k < sumOfProbsForRegion.length; ++k) {
                int n = k;
                sumOfProbsForRegion[n] = sumOfProbsForRegion[n] + sumOfProbsForLocation[k] * sumOfWeights;
            }
        }
        Utils.normalize(sumOfProbsForRegion);
        double[] tempDist = new double[sumOfProbsForRegion.length];
        System.arraycopy(sumOfProbsForRegion, 0, tempDist, 0, sumOfProbsForRegion.length);
        return tempDist;
    }

    private double getRandomX(int pix) {
        double minPix = this.m_minX + (double)pix * this.m_pixWidth;
        return minPix + this.m_random.nextDouble() * this.m_pixWidth;
    }

    private double getRandomY(int pix) {
        double minPix = this.m_minY + (double)pix * this.m_pixHeight;
        return minPix + this.m_random.nextDouble() * this.m_pixHeight;
    }

    @Override
    public TaskStatusInfo getTaskStatus() {
        return this.m_status;
    }
}

