/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import weka.experiment.Experiment;
import weka.gui.experiment.SetupPanel;
import weka.gui.experiment.SimpleSetupPanel;

public class SetupModePanel
extends JPanel {
    private static final long serialVersionUID = -3758035565520727822L;
    protected JRadioButton m_SimpleSetupRBut = new JRadioButton("Simple");
    protected JRadioButton m_AdvancedSetupRBut = new JRadioButton("Advanced");
    protected SimpleSetupPanel m_simplePanel = new SimpleSetupPanel();
    protected SetupPanel m_advancedPanel = new SetupPanel();

    public SetupModePanel() {
        this.m_simplePanel.setModePanel(this);
        this.m_SimpleSetupRBut.setMnemonic('S');
        this.m_SimpleSetupRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupModePanel.this.switchToSimple(null);
            }
        });
        this.m_AdvancedSetupRBut.setMnemonic('A');
        this.m_AdvancedSetupRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupModePanel.this.switchToAdvanced(null);
            }
        });
        ButtonGroup modeBG = new ButtonGroup();
        modeBG.add(this.m_SimpleSetupRBut);
        modeBG.add(this.m_AdvancedSetupRBut);
        this.m_SimpleSetupRBut.setSelected(true);
        JPanel modeButtons = new JPanel();
        modeButtons.setLayout(new GridLayout(1, 0));
        modeButtons.add(this.m_SimpleSetupRBut);
        modeButtons.add(this.m_AdvancedSetupRBut);
        JPanel switchPanel = new JPanel();
        switchPanel.setLayout(new GridLayout(1, 0));
        switchPanel.add(new JLabel("Experiment Configuration Mode:"));
        switchPanel.add(modeButtons);
        this.setLayout(new BorderLayout());
        this.add((Component)switchPanel, "North");
        this.add((Component)this.m_simplePanel, "Center");
    }

    public void switchToAdvanced(Experiment exp) {
        if (exp == null) {
            exp = this.m_simplePanel.getExperiment();
        }
        if (exp != null) {
            this.m_AdvancedSetupRBut.setSelected(true);
            this.m_advancedPanel.setExperiment(exp);
        }
        this.remove(this.m_simplePanel);
        this.m_simplePanel.removeNotesFrame();
        this.add((Component)this.m_advancedPanel, "Center");
        this.validate();
        this.repaint();
    }

    public void switchToSimple(Experiment exp) {
        if (exp == null) {
            exp = this.m_advancedPanel.getExperiment();
        }
        if (exp != null && !this.m_simplePanel.setExperiment(exp)) {
            this.m_AdvancedSetupRBut.setSelected(true);
            this.switchToAdvanced(exp);
        } else {
            this.remove(this.m_advancedPanel);
            this.m_advancedPanel.removeNotesFrame();
            this.add((Component)this.m_simplePanel, "Center");
            this.validate();
            this.repaint();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_simplePanel.addPropertyChangeListener(l);
        this.m_advancedPanel.addPropertyChangeListener(l);
    }

    public Experiment getExperiment() {
        if (this.m_SimpleSetupRBut.isSelected()) {
            return this.m_simplePanel.getExperiment();
        }
        return this.m_advancedPanel.getExperiment();
    }
}

